// LISTING 13.14. Utworzenie załącznika w zgłoszeniu Jiry

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.issue.attachment.CreateAttachmentParamsBean;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia.
def issue = ComponentAccessor.getIssueManager().getIssueObject("TP2-3");

// 2. Pobranie menedżerów.
def attachmentPathManager = ComponentAccessor.getAttachmentPathManager();

// 3. Pobranie obiektu typu interfejsowego ApplicationUser bieżącego użytkownika.
def currentUser = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();

// 4. Tekst do umieszczenia w plikach.
String fileContent = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\nNisl tincidunt eget nullam non. \nQuis hendrerit dolor magna eget est lorem ipsum dolor sit. \nVolutpat odio facilisis mauris sit amet massa. \nCommodo odio aenean sed adipiscing diam donec adipiscing tristique.";

// 5. Utworzenie pliku *.txt na serwerze i dodanie go jako załącznika do zgłoszenia.
String textFilename = "text.txt";
File textFile = new File("/var/atlassian/application-data/jira/tmp/${textFilename}");

// Dodanie treści pliku i zapisanie go na serwerze.
try {
    BufferedWriter writer = new BufferedWriter(new FileWriter(textFile));
    writer.write(fileContent);
    writer.close();

    // Dodanie zapisanego pliku jako załącznik do zgłoszenia.
    createAttachment(textFile, textFilename, currentUser, issue);

    // Usunięcie tymczasowego pliku z katalogu /var/atlassian/application-data/jira/tmp/.
    textFile.delete()
} catch(IOException ex) {
    log.error(ex.getMessage());
}

// 6. Metoda dodająca załącznik do zgłoszenia.
def createAttachment(File file, String filename, ApplicationUser currentUser, Issue issue) {
    def attachmentManager = ComponentAccessor.getAttachmentManager();
    def bean = new CreateAttachmentParamsBean.Builder()
        .file(file)
        .filename(filename)
        .contentType("text/plain")
        .author(currentUser)
        .issue(issue)
        .build();
    attachmentManager.createAttachment(bean);
}