// LISTING 12.20. Wyświetlenie wartości zwracanej przez scripted field typu user picker (single user)

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.component.ComponentAccessor;
import java.time.temporal.WeekFields;
import java.time.DayOfWeek;

// 1. Ustawienie poniedziałku jako pierwszego dnia tygodnia.
WeekFields weekFields = WeekFields.of(DayOfWeek.MONDAY, 1);

// 2. Ustawienie rzeczoznawcy w zależności od aktualnego dnia tygodnia.
def dateNow = new Date();
ApplicationUser appraiser;

if ([1, 3, 5].contains(dateNow.toLocalDateTime().get(weekFields.dayOfWeek())))
    appraiser = ComponentAccessor.getUserManager().getUserByName("jkowalski");
else
    appraiser = ComponentAccessor.getUserManager().getUserByName("anowak");

// 3. Zwrócenie wyniku.
return appraiser;