// LISTING 12.1. Pobieranie wartości z system fieldów

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("ZSS-1");

// 3. Pobranie wartości system fieldów.

// Description — zwracany typ: String.
def description = issue.getDescription();

// Summary — zwracany typ: String.
def summary = issue.getSummary();

// Issue type — zwracany typ: com.atlassian.jira.issue.issuetype.IssueTypeImpl.
def issueTypeObject = issue.getIssueType();
def issueTypeName = issue.getIssueType().getName();
def issueTypeId = issue.getIssueTypeId();

// Priority — zwracany typ: com.atlassian.jira.issue.priority.PriorityImpl.
def priorityObject = issue.getPriority();
def priorityName = issue.getPriority().getName();

// Resolution — zwracany typ: com.atlassian.jira.issue.resolution.ResolutionImpl.
// Operator obiektowy ? zabezpiecza przed wykonaniem metody getName() na obiekcie, który miałby wartość null.
def resolutionObject = issue.getResolution();
def resolutionName = issue.getResolution()?.getName();

// Assignee — zwracany typ: com.atlassian.jira.user.DelegatingApplicationUser.
def assignee = issue.getAssignee();
def assigneeUserName = assignee?.getName();

// Reporter — zwracany typ: com.atlassian.jira.user.DelegatingApplicationUser.
def reporter = issue.getReporter();
def reporterUserName = reporter?.getName();

// Due Date — zwracany typ: java.sql.Timestamp.
def dueDate = issue.getDueDate();

// Labels — zwracany typ: java.util.TreeSet<com.atlassian.jira.issue.label.Label>.
// Wyświetlenie jako ciąg znaków z nazwami rozdzielonymi przecinkami.
String labels = String.join(", ", issue.getLabels().collect() {label -> label.getLabel()});

// 4. Wyświetlenie wyników.
// description: Example description | summary: Test issue | issueTypeName: Story | issueTypeId:
// 10001 | priorityName: Medium | resolutionName: Done | assigneeUserName: jkowalski |
// reporterUserName: jkowalski | labels: label1, label2, label3, label4
return "description: ${description} | summary: ${summary} | issueTypeName: ${issueTypeName} | issueTypeId: ${issueTypeId} | priorityName: ${priorityName} | resolutionName: ${resolutionName} | assigneeUserName: ${assigneeUserName} | reporterUserName: ${reporterUserName} | labels: ${labels}";