// LISTING 10.3. Wstrzykiwanie zależności

/* Dodanie zależności do pliku pom.xml zlokalizowanego w katalogu pluginu. 
<dependencies>
[...]
<dependency>
<groupId>com.atlassian.confluence</groupId>
<artifactId>confluence</artifactId>
<version>6.14.0</version>
<scope>provided</scope>
</dependency>
[…]
</dependencies>
*/

// KLASA A (obiekt tej klasy będzie wstrzykiwany).
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SpaceService {
    // ##### Komponenty do wstrzyknięcia.
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;
    private final UserAccessor userAccessor;
    
    // ##### Konstruktory.
    @Inject
    public SpaceService(
        @ComponentImport SpaceManager spaceManager,
        @ComponentImport SpacePermissionManager spacePermissionManager,
        @ComponentImport UserAccessor userAccessor) {
            this.spaceManager = spaceManager;
            this.spacePermissionManager = spacePermissionManager;
            this.userAccessor = userAccessor;
    }
    
// Pozostałe konstruktory, gettery i settery.
}

// KLASA B (do tej klasy będzie wstrzyknięty obiekt klasy A).
import com.atlassian.user.User;

public class ApiController {
    @Inject
    private SpaceService spaceService;

    // Konstruktory, gettery, settery.
}