from struct import unpack
import sys
import os

# Odczyt ustalonej liczby bajtw
def read_bytes(f, l):
    bytes = f.read(l)
    if len(bytes) != l:
        raise Exception("Nieoczekiwany koniec strumienia")
    return bytes

# Wczytanie 4 bajtw w kolejnoci sieciowej (big endian) jako liczby cakowitej
def read_int(f):
    return unpack("!i", read_bytes(f, 4))[0]

# Odczyt pojedynczego bajtu
def read_byte(f):
    return ord(read_bytes(f, 1))


filename = sys.argv[1]
file_size = os.path.getsize(filename)

f = open(filename, "rb")
print("Marker: %s" % read_bytes(f, 4))

# Kontynuowanie czytania z pliku a do wyczerpania danych
while f.tell() < file_size:
    length = read_int(f)
    unk1 = read_int(f)
    unk2 = read_byte(f)
    data = read_bytes(f, length - 1)
    print("Dugo: %d, Nieznane-1: %d, Nieznane-2: %d, Dane: %s" 
        % (length, unk1, unk2, data))
