-- Deklaracja protokou SuperFunkyChat dla dysekcji
chat_proto = Proto("chat","SuperFunkyChat Protocol")
-- Specyfikacja pl protokou
chat_proto.fields.chksum = ProtoField.uint32("chat.chksum", "Checksum", base.HEX)
chat_proto.fields.command = ProtoField.uint8("chat.command", "Command")
chat_proto.fields.data = ProtoField.bytes("chat.data", "Data")

-- Funkcja dysektora:
-- buffer: Dane pakietu UDP jako "Testy Virtual Buffer" (TVB)
-- pinfo: Informacja o pakiecie
-- tree: Korze drzewa UI
function chat_proto.dissector(buffer, pinfo, tree)
    -- Wywietlana w kolumnie protokou
    pinfo.cols.protocol = "CHAT"
    
    -- Tworzenie poddrzewa reprezentujcego cay bufor
    local subtree = tree:add(chat_proto, buffer(),
                             "Dane protokou SuperFunkyChat ")
    subtree:add(chat_proto.fields.chksum, buffer(0, 4))
    subtree:add(chat_proto.fields.command, buffer(4, 1))
    subtree:add(chat_proto.fields.data, buffer(5))
end

-- Dodanie portu 12345 do tablicy dysektora
udp_table = DissectorTable.get("udp.port")
udp_table:add(12345, chat_proto)
