using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;

public partial class TrackOrder : System.Web.UI.Page
{
    decimal subTotal;
    protected void Page_Load(object sender, EventArgs e)
    {
        this.Master.PageSubHeading.Text = ">> ledzenie stanu zamwie!";
        if (!Page.IsPostBack)
        {
            if (Page.User.Identity.IsAuthenticated)
            {
                if (!Page.User.IsInRole("Customer"))
                {
                    this.Master.ErrorMessage.Text = "Aby ledzi zamwienia, musisz zalogowa si jako klient!";
                    this.pnlOrder.Visible = false;
                }
                else
                {
                    OrderTableAdapter OrderAdapter = new OrderTableAdapter();
                    MembershipUser myObject = Membership.GetUser();
                    Guid UserID = (Guid)myObject.ProviderUserKey;
                    object OrderCount = OrderAdapter.OrderCount(UserID);
                    if ((int)OrderCount == 0)
                    {
                        this.Master.ErrorMessage.Text = "Nie ma zoonych zamwie! Najpierw musisz co kupi!";                        this.pnlOrder.Visible = false;
                    }
                    else
                    {
                        this.pnlOrder.Visible = true;
                    }
                }
            }
            else
            {
                this.Master.ErrorMessage.Text = "** Zaloguj si, aby skada zamwienia na produkty! **";
                this.pnlOrder.Visible = false;
            }
        }
    }

    protected void gvCart_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            subTotal += decimal.Parse(((Label)e.Row.FindControl("Price")).Text);
        }
        if (e.Row.RowType == DataControlRowType.Footer)
        {
            ((Label)e.Row.FindControl("SubTotal")).Text = subTotal.ToString();
            ((Label)e.Row.FindControl("TotalAmount")).Text = Convert.ToString(subTotal + decimal.Parse(((Label)e.Row.FindControl("Tax")).Text) - decimal.Parse(((Label)e.Row.FindControl("Discount")).Text) + decimal.Parse(((Label)e.Row.FindControl("ShippingCharges")).Text));
        }
    }
}
