<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Register.aspx.cs" Inherits="Register" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div>
        <asp:CreateUserWizard ID="CreateUserWizard1" runat="server" BackColor="#E3EAEB" BorderColor="#E6E2D8"
            BorderStyle="Solid" BorderWidth="1px" Font-Names="Verdana" Font-Size="0.8em" 
            OnCreatedUser="CreateUserWizard1_CreatedUser"
            EmailRegularExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" ContinueDestinationPageUrl="~/Default.aspx" CreateUserButtonText="Utwrz">
            <WizardSteps>
          <asp:CreateUserWizardStep ID="CreateUserWizardStep1" runat="server">
            <ContentTemplate>
              <table border="0">
                <tr>
                  <td align="center" colspan="2">
                    Utwrz konto</td>
                </tr>
                <tr>
                  <td align="right">
                    <label class="ContentSmall" for="UserName">
                      Nazwa uytkownika:</label></td>
                  <td>
                    <asp:TextBox ID="UserName" runat="server"></asp:TextBox>
                    <cc1:TextBoxWatermarkExtender ID="TextBoxWatermarkExtender1" runat="server" Enabled="True"
                          TargetControlID="UserName" WatermarkText="Enter User Name" WatermarkCssClass="Transparent">
                      </cc1:TextBoxWatermarkExtender>
                    <asp:RequiredFieldValidator ControlToValidate="UserName" ErrorMessage="User Name is required."
                      ID="UserNameRequired" runat="server" ToolTip="User Name is required." ValidationGroup="CreateUserWizard1">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender1" runat="server" TargetControlID="UserNameRequired">
                      </cc1:ValidatorCalloutExtender>
                  </td>
                </tr>
                <tr>
                  <td align="right">
                    <label class="ContentSmall" for="Password">
                      Haso:</label></td>
                  <td>
                    <asp:TextBox ID="Password" runat="server" TextMode="Password"></asp:TextBox>
                    <cc1:PasswordStrength ID="PasswordStrength1" runat="server" TargetControlID="Password">
                    </cc1:PasswordStrength>
                    <asp:RequiredFieldValidator ControlToValidate="Password" ErrorMessage="Password is required."
                      ID="PasswordRequired" runat="server" ToolTip="Password is required." ValidationGroup="CreateUserWizard1">*</asp:RequiredFieldValidator>
                  </td>
                </tr>
                <tr>
                  <td align="right">
                    <label class="ContentSmall" for="ConfirmPassword">
                      Potwierd haso:</label></td>
                  <td>
                    <asp:TextBox ID="ConfirmPassword" runat="server" TextMode="Password"></asp:TextBox>
                    <asp:RequiredFieldValidator ControlToValidate="ConfirmPassword" ErrorMessage="Confirm Password is required."
                      ID="ConfirmPasswordRequired" runat="server" ToolTip="Confirm Password is required."
                      ValidationGroup="CreateUserWizard1">*</asp:RequiredFieldValidator>
                  </td>
                </tr>
                <tr>
                  <td align="right">
                    <label class="ContentSmall" for="Email">
                      E-mail:</label></td>
                  <td>
                    <asp:TextBox ID="Email" runat="server"></asp:TextBox>
                    <asp:RequiredFieldValidator ControlToValidate="Email" ErrorMessage="E-mail is required."
                      ID="EmailRequired" runat="server" ToolTip="E-mail is required." ValidationGroup="CreateUserWizard1">*</asp:RequiredFieldValidator>
                  </td>
                </tr>
                <tr>
                  <td align="right">
                    <label class="ContentSmall" for="Question">
                      Pytanie bezpieczestwa:</label></td>
                  <td>
                    <asp:TextBox ID="Question" runat="server"></asp:TextBox>
                    <asp:RequiredFieldValidator ControlToValidate="Question" ErrorMessage="Security question is required."
                      ID="QuestionRequired" runat="server" ToolTip="Security question is required." ValidationGroup="CreateUserWizard1">*</asp:RequiredFieldValidator>
                  </td>
                </tr>
                <tr>
                  <td align="right">
                    <label class="ContentSmall" for="Answer">
                      Odpowied:</label></td>
                  <td>
                    <asp:TextBox ID="Answer" runat="server"></asp:TextBox>
                    <asp:RequiredFieldValidator ControlToValidate="Answer" ErrorMessage="Security answer is required."
                      ID="AnswerRequired" runat="server" ToolTip="Security answer is required." ValidationGroup="CreateUserWizard1">*</asp:RequiredFieldValidator>
                  </td>
                </tr>
                <tr>
                  <td align="center" colspan="2">
                    <asp:CompareValidator ControlToCompare="Password" ControlToValidate="ConfirmPassword"
                      Display="Dynamic" ErrorMessage="Haso i potwierdzenia hasa musz by identyczne."
                      ID="PasswordCompare" runat="server" ValidationGroup="CreateUserWizard1"></asp:CompareValidator>
                  </td>
                </tr>
                <tr>
                  <td align="center" colspan="2" style="color: red">
                    <asp:Literal EnableViewState="False" ID="ErrorMessage" runat="server"></asp:Literal>
                  </td>
                </tr>
                <tr>
                  <td colspan="2">
                  </td>
                </tr>
              </table>
            </ContentTemplate>
          </asp:CreateUserWizardStep>
          <asp:CompleteWizardStep ID="CompleteWizardStep1" runat="server">
            <ContentTemplate>
              <table border="0">
                <tr>
                  <td align="center" colspan="2">
                    Koniec</td>
                </tr>
                <tr>
                  <td>
                    Konto zostao pomylnie utworzone.</td>
                </tr>
                <tr>
                  <td align="right" colspan="2">
                    <asp:Button CausesValidation="False" CommandName="Continue" ID="ContinueButton" runat="server"
                      Text="Dalej" ValidationGroup="CreateUserWizard1" />
                  </td>
                </tr>
                </table>
            </ContentTemplate>
          </asp:CompleteWizardStep>
        </WizardSteps>
            <SideBarStyle BackColor="#1C5E55" Font-Size="0.9em" VerticalAlign="Top" />
            <TitleTextStyle BackColor="#1C5E55" Font-Bold="True" ForeColor="White" />
            <SideBarButtonStyle ForeColor="White" />
            <NavigationButtonStyle BackColor="White" BorderColor="#C5BBAF" BorderStyle="Solid"
                BorderWidth="1px" Font-Names="Verdana" ForeColor="#1C5E55" />
            <HeaderStyle BackColor="#666666" BorderColor="#E6E2D8" BorderStyle="Solid" BorderWidth="2px"
                Font-Bold="True" Font-Size="0.9em" ForeColor="White" HorizontalAlign="Center" />
            <CreateUserButtonStyle BackColor="White" BorderColor="#C5BBAF" BorderStyle="Solid"
                BorderWidth="1px" Font-Names="Verdana" ForeColor="#1C5E55" />
            <ContinueButtonStyle BackColor="White" BorderColor="#C5BBAF" BorderStyle="Solid"
                BorderWidth="1px" Font-Names="Verdana" ForeColor="#1C5E55" />
            <StepStyle BorderWidth="0px" />
        </asp:CreateUserWizard>
        
    </div>
</asp:Content>