<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="PendingOrders.aspx.cs" Inherits="PendingOrders" Title="Oczekujce zamwienia" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<asp:Panel ID="pnlMain" runat="server">
    <div class="ContentSmall">
        Poniej znajduje si lista zamwie, ktre oczekuj na realizacj.<br />
        Zadaniem administratora lub managera jest dopilnowanie, aby towar zosta wysany i dostarczony do klienta.<br />
        Ponadto naley odpowiednio zmieni jego stan. <br />
        Uytkownik bdzie mg sprawdzi stan swojego zamwienia tylko, jeli informacje te zostan zdefiniowane tutaj.
    </div><br /><br />
    <asp:GridView ID="gvPendingOrders" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="OrderId" AllowSorting="True" AutoGenerateColumns="False"
    SelectedIndex="0" OnSelectedIndexChanged="gvPendingOrders_SelectedIndexChanged" 
    OnPageIndexChanged="gvPendingOrders_PageIndexChanged" RowStyle-CssClass="ContentSmall"
    OnSorted="gvPendingOrders_Sorted" OnRowDataBound="gvPendingOrders_OnRowDataBound">
    <Columns>
      <asp:CommandField ButtonType="Button" ShowSelectButton="True" SelectText="Zmie stan" />
      <asp:BoundField DataField="OrderId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="OrderId" />
      <asp:BoundField DataField="OrderDate" HeaderText="Data" SortExpression="OrderDate" />
      <asp:BoundField DataField="OrderStatus" HeaderText="Stan" SortExpression="OrderStatus" />
      <asp:BoundField DataField="TotalAmount" HeaderText="Suma" SortExpression="TotalAmount" />
      <asp:BoundField DataField="UserName" HeaderText="Imi i nazwisko klienta" SortExpression="UserName" />
      <asp:TemplateField HeaderText="Adres klienta" SortExpression="City">
        <ItemTemplate>
            <asp:Label ID="CustomerAddress" runat="server"></asp:Label>
        </ItemTemplate>
      </asp:TemplateField>
    </Columns>
        <RowStyle CssClass="ContentSmall" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" SelectMethod="GetPendingOrders" 
   TypeName="ShoppingCartTableAdapters.PendingOrdersTableAdapter">
    </asp:ObjectDataSource>
</asp:Panel>
<asp:Panel ID="pnlDetails" runat="server">
<h4>Szczegy zamwienia</h4>
<asp:DetailsView AutoGenerateRows="False" DataSourceID="DetailsViewDataSource" DataKeyNames="OrderId" 
    CssClass="Table" ID="dvOrderStatus" RowStyle-CssClass="ContentSmall" runat="server" AutoGenerateEditButton="True" 
    OnItemUpdated="dvOrderStatus_ItemUpdated" OnModeChanging="dvOrderStatus_ModeChanging" Width="367px" EnableViewState="False">
    <Fields>
        <asp:TemplateField HeaderText="Identyfikator zam&#243;wienia" SortExpression="OrderId">
            <EditItemTemplate>
                <asp:Label ID="EditOrderId" runat="server" Text='<%# Bind("OrderId") %>'></asp:Label>
            </EditItemTemplate>
            <ItemTemplate>
                <asp:Label ID="OrderId" runat="server" Text='<%# Bind("OrderId") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Stan zam&#243;wienia" SortExpression="OrderStatus">
            <EditItemTemplate>
                <asp:DropDownList ID="EditOrderStatus" runat="server" SelectedValue='<%# Bind("OrderStatus") %>'>
                    <asp:ListItem Value="Confirmed" Text="Confirmed"></asp:ListItem>                
                    <asp:ListItem Value="Dispatched" Text="Dispatched"></asp:ListItem>                
                    <asp:ListItem Value="Shipped" Text="Shipped"></asp:ListItem>                
                </asp:DropDownList>
            </EditItemTemplate>
            <ItemTemplate>
                <asp:Label ID="OrderStatus" runat="server" Text='<%# Bind("OrderStatus") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
    </Fields>
    <RowStyle CssClass="ContentSmall" />
  </asp:DetailsView><br />
  <asp:ObjectDataSource ID="DetailsViewDataSource" runat="server" 
        OldValuesParameterFormatString="{0}" SelectMethod="GetOrderDetails" OnUpdating="DetailsViewDataSource_Updating"
        TypeName="ShoppingCartTableAdapters.OrderTableAdapter" UpdateMethod="UpdateOrderStatus" >
        <SelectParameters>
              <asp:ControlParameter ControlID="gvPendingOrders" Name="OrderId" PropertyName="SelectedValue"
                Type="Int32" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="OrderId" Type="Int32" />
        </UpdateParameters>
    </asp:ObjectDataSource>
    <asp:GridView ID="gvCart" runat="server" CssClass="Table" DataSourceID="GridViewDataSource1" 
    DataKeyNames="CartDetailsId" AutoGenerateColumns="False" SelectedIndex="0" OnRowDataBound="gvCart_RowDataBound" HeaderStyle-CssClass="ContentMedium" 
    RowStyle-CssClass="ContentSmall" FooterStyle-CssClass="ContentSmall" ShowFooter="True" CellPadding="5">
    <Columns>
      <asp:TemplateField>
        <ItemTemplate>
            <asp:TextBox ID="CartDetailsId" runat="server" Text='<%# Eval("CartDetailsId") %>' Width="30" Visible="false"></asp:TextBox>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="ProductId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="ProductId" />
      <asp:BoundField DataField="ProductName" HeaderText="Nazwa" SortExpression="ProductName" />
      <asp:TemplateField HeaderText="Liczba">
        <ItemTemplate>
            <asp:Label ID="Quantity" runat="server" Text='<%# Eval("QuantityOrdered") %>' Width="30"></asp:Label>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena jednostkowa">
        <ItemTemplate>
            <asp:Label ID="UnitPrice" runat="server" Text='<%# Eval("UnitPrice") %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="lblSubTotal" runat="server" Text="Sub Total : "></asp:Label><br />
            <asp:Label ID="lblTax" runat="server" Text="Tax : "></asp:Label><br />
            <asp:Label ID="lblDiscount" runat="server" Text="Discount : "></asp:Label><br />
            <asp:Label ID="lblShippingCharges" runat="server" Text="Shipping & Handling Charges : "></asp:Label><br /><br />
            <asp:Label ID="lblTotalAmount" runat="server" Text="Total Amount (in US$) : "></asp:Label>
        </FooterTemplate>
          <ItemStyle HorizontalAlign="Right" />
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena">
        <ItemTemplate>
            <asp:Label ID="Price" runat="server" Text='<%# Eval("Price") %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="SubTotal" runat="server" Width="70" dir="rtl"/><br />
            <asp:Label ID="Tax" runat="server" Width="70" dir="rtl" Text="30.00"/><br />
            <asp:Label ID="Discount" runat="server" Width="70" dir="rtl" Text="5.00"/><br />
            <asp:Label ID="ShippingCharges" runat="server" Width="70" dir="rtl" Text="15.00"/><br /><br />
            <asp:Label ID="TotalAmount" runat="server" Width="70" dir="rtl"/>
        </FooterTemplate>
          <ItemStyle HorizontalAlign="Right" />
      </asp:TemplateField>
    </Columns>
        <FooterStyle CssClass="ContentSmall" />
        <RowStyle CssClass="ContentSmall" />
        <HeaderStyle CssClass="ContentMedium" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource1" runat="server" 
        SelectMethod="GetCartDetailsByOrderId" TypeName="ShoppingCartTableAdapters.CartDetailsTableAdapter">
        <SelectParameters>
            <asp:ControlParameter ControlID="gvPendingOrders" Name="OrderId" PropertyName="SelectedValue"
                Type="Int32" /></SelectParameters>
    </asp:ObjectDataSource>

</asp:Panel>
</asp:Content>