<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Order.aspx.cs" Inherits="Order" Title="Generate Order" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<asp:Panel ID="pnlOrder" runat="server">
<h4>Szczegy zamwienia</h4>
<asp:GridView ID="gvCart" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="CartDetailsId" AutoGenerateColumns="False" SelectedIndex="0" OnRowDataBound="gvCart_RowDataBound" HeaderStyle-CssClass="ContentMedium" 
    RowStyle-CssClass="ContentSmall" FooterStyle-CssClass="ContentSmall" ShowFooter="True" CellPadding="5">
    <Columns>
      <asp:TemplateField>
        <ItemTemplate>
            <asp:TextBox ID="CartDetailsId" runat="server" Text='<%# Eval("CartDetailsId") %>' Width="30" Visible="false"></asp:TextBox>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="ProductId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="ProductId" />
      <asp:BoundField DataField="ProductName" HeaderText="Nazwa" SortExpression="ProductName" />
      <asp:TemplateField HeaderText="Liczba">
        <ItemTemplate>
            <asp:Label ID="Quantity" runat="server" Text='<%# Eval("QuantityOrdered") %>' Width="30"></asp:Label>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena jednostkowa">
        <ItemTemplate>
            <asp:Label ID="UnitPrice" runat="server" Text='<%# Eval("UnitPrice") %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="lblSubTotal" runat="server" Text="Suma czciowa: "></asp:Label><br />
            <asp:Label ID="lblTax" runat="server" Text="Podatek: "></asp:Label><br />
            <asp:Label ID="lblDiscount" runat="server" Text="Rabat: "></asp:Label><br />
            <asp:Label ID="lblShippingCharges" runat="server" Text="Opata za przesyk: "></asp:Label><br /><br />
            <asp:Label ID="lblTotalAmount" runat="server" Text="Suma: "></asp:Label>
        </FooterTemplate>
          <ItemStyle HorizontalAlign="Right" />
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena">
        <ItemTemplate>
            <asp:Label ID="Price" runat="server" Text='<%# Eval("Price") %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="SubTotal" runat="server" Width="70" dir="rtl"/><br />
            <asp:Label ID="Tax" runat="server" Width="70" dir="rtl" Text="30.00"/><br />
            <asp:Label ID="Discount" runat="server" Width="70" dir="rtl" Text="5.00"/><br />
            <asp:Label ID="ShippingCharges" runat="server" Width="70" dir="rtl" Text="15.00"/><br /><br />
            <asp:Label ID="TotalAmount" runat="server" Width="70" dir="rtl"/>
        </FooterTemplate>
          <ItemStyle HorizontalAlign="Right" />
      </asp:TemplateField>
    </Columns>
    <FooterStyle CssClass="ContentSmall" />
    <RowStyle CssClass="ContentSmall" />
    <HeaderStyle CssClass="ContentMedium" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" 
        SelectMethod="GetCartDetails" TypeName="ShoppingCartTableAdapters.CartDetailsTableAdapter">
        <SelectParameters>
            <asp:QueryStringParameter Name="UserId" DefaultValue="01be2d91-f762-4847-bde2-c4457789ddb0" QueryStringField="UserId" /></SelectParameters>
    </asp:ObjectDataSource>
<h4>Podaj adres przesyki</h4>
<table width="500" class="Table">
    <tr>
        <td>
            <asp:TextBox ID="AddressId" runat="server" Visible="false"></asp:TextBox> 
            <div class="ContentSmall">
                Adres:
            </div>
            <asp:TextBox ID="Address" runat="server" TextMode="MultiLine" Rows="3" Columns="25"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="Address" ErrorMessage="Podaj adres."
                       ID="AddressRequired" runat="server" ToolTip="Podaj adres.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender1" runat="server" TargetControlID="AddressRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
        <td>
            <div class="ContentSmall">
                Miasto:
            </div>
            <asp:TextBox ID="City" runat="server"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="City" ErrorMessage="Podaj miasto."
                       ID="CityRequired" runat="server" ToolTip="Podaj miasto.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender2" runat="server" TargetControlID="CityRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
    </tr>
    <tr>
        <td>
            <div class="ContentSmall">
                Wojewdztwo:
            </div>
            <asp:TextBox ID="State" runat="server"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="State" ErrorMessage="Podaj wojewdztwo."
                       ID="StateRequired" runat="server" ToolTip="Podaj wojewdztwo.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender3" runat="server" TargetControlID="StateRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
        <td>
            <div class="ContentSmall">
                Kraj:
            </div>
            <asp:TextBox ID="Country" runat="server"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="Country" ErrorMessage="Podaj kraj."
                       ID="CountryRequired" runat="server" ToolTip="Podaj kraj.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender4" runat="server" TargetControlID="CountryRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
    </tr>
    <tr>
        <td>
            <div class="ContentSmall">
                Kod pocztowy:
            </div>
            <asp:TextBox ID="Zipcode" runat="server"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="Zipcode" ErrorMessage="Podaj kod pocztowy."
                       ID="ZipcodeRequired" runat="server" ToolTip="Podaj kod pocztowy.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender5" runat="server" TargetControlID="ZipcodeRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
        <td>
            <div class="ContentSmall">
                Numer telefoniczny:
            </div>
            <asp:TextBox ID="ContactNo" runat="server"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="ContactNo" ErrorMessage="Podaj numer telefonu."
                       ID="ContactNumberRequired" runat="server" ToolTip="Podaj numer telefonu.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender6" runat="server" TargetControlID="ContactNumberRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
    </tr>
</table>
<h4>Szczegy patnoci</h4>
<table width="500" class="Table">
    <tr>
        <td>
            <div class="ContentSmall">
                Numer karty kredytowej:
            </div>
            <asp:TextBox ID="CreditCardNo" runat="server"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="CreditCardNo" ErrorMessage="Podaj numer karty kredytowej."
                       ID="CreditCardNoRequired" runat="server" ToolTip="Podaj numer karty kredytowej.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender7" runat="server" TargetControlID="CreditCardNoRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
    </tr>
    <tr>
        <td>
            <div class="ContentSmall">
                Numer CVV : </div>
            <asp:TextBox ID="CVVNo" runat="server" TextMode="Password"></asp:TextBox>
            <asp:RequiredFieldValidator ControlToValidate="CVVNo" ErrorMessage="Podaj numer CVV."
                       ID="CVVNoRequired" runat="server" ToolTip="Podaj numer CVV.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender8" runat="server" TargetControlID="CVVNoRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
    </tr>
    <tr>
        <td>
            <div class="ContentSmall">
                Data wanoci:
            </div>
            <asp:DropDownList ID="ExpiryDate" runat="server"></asp:DropDownList>
            <asp:RequiredFieldValidator ControlToValidate="ExpiryDate" ErrorMessage="Podaj dat wanoci karty."
                       ID="ExpiryDateRequired" runat="server" ToolTip="Podaj dat wanoci karty.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender9" runat="server" TargetControlID="ExpiryDateRequired">
                      </cc1:ValidatorCalloutExtender>
        </td>
   </tr>
</table>
<br />
<asp:Button ID="btnPlaceOrder" runat="server" Text="Zamawiam" OnClick="btnPlaceOrder_Click" /></asp:Panel>
<asp:Panel ID="pnlConfirm" runat="server">
<div class="ContentMedium">
    Zamwienie zostao przyjte!
    <br />
    Aby sprawdzi stan jego realizacji, kliknij odnonik Stan zamwienia.</div>
</asp:Panel>
</asp:Content>