<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Cart.aspx.cs" Inherits="Cart" Title="Koszyk" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<script language="javascript" type="text/javascript">
  function UpdatePrice(txtQty, txtPrice, OriginalPrice, CartDetailsId)
    {
        if (txtQty.value != "")
        {
            txtPrice.value = txtQty.value * OriginalPrice;
            PageMethods.UpdateCart(txtQty.value, txtPrice.value, CartDetailsId, OnSucceeded, OnFailed);
        }
    }

    // Funkcja zwrotna wywoywana w przypadku pomylnego  
    // zakoczenia dziaania metody strony.
    function OnSucceeded(result, userContext, methodName) 
    {
        if (methodName == "UpdateCart")
        {
            //alert("Aktualizacja koszyka zakoczona pomylnie!");
        }
    }
    // Funkcja zwrotna wywoywana w przypadku niepowodzenia 
    // metody strony.
    function OnFailed(error, userContext, methodName) 
    {
        if(error !== null) 
        {
            alert("Nie mona zaktualizowa ceny. " + error.get_message());
        }
    }

</script>
<asp:Label ID="lblNote" runat="server" CssClass="ContentSmall" Text="Instrukcje: <br />Aby zmieni liczb egzemplarzy zamawianego produktu, wpisz now warto w kolumnie Liczba. <br />
Aby przej do zamawiania produktw, kliknij przycisk Kasa. <br />Jeli chcesz kontynuowa zakupy, kliknij przycisk Kontynuuj zakupy.">
</asp:Label>
<br /><br />
<asp:GridView ID="gvCart" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="CartDetailsId" AutoGenerateColumns="False" SelectedIndex="0" OnRowDataBound="gvCart_RowDataBound"
    OnRowDeleted="gvCart_RowDeleted" ShowFooter="True"  HeaderStyle-CssClass="ContentMedium" 
    RowStyle-CssClass="ContentSmall" FooterStyle-CssClass="ContentSmall" CellPadding="3">
    <Columns>
      <asp:CommandField ButtonType="Button" ShowDeleteButton="True" DeleteText="Usu" />
      <asp:TemplateField>
        <ItemTemplate>
            <asp:TextBox ID="CartDetailsId" runat="server" Text='<%# Eval("CartDetailsId") %>' Width="30" Visible="false"></asp:TextBox>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="ProductId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="ProductId" />
      <asp:BoundField DataField="ProductName" HeaderText="Nazwa" SortExpression="ProductName" />
      <asp:TemplateField HeaderText="Liczba">
        <ItemTemplate>
            <asp:TextBox ID="Quantity" runat="server" Text='<%# Eval("QuantityOrdered") %>' Width="30"></asp:TextBox>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena jednostkowa">
        <ItemTemplate>
            <asp:TextBox ID="UnitPrice" runat="server" dir="rtl" Text='<%# Eval("UnitPrice") %>' Width="70" Enabled="false"></asp:TextBox>
        </ItemTemplate>
        <FooterTemplate>
            <div class="ContentMedium" style="text-align:right">Suma: </div>
        </FooterTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena">
        <ItemTemplate>
            <asp:TextBox ID="Price" runat="server" dir="rtl" Text='<%# Eval("Price") %>' Width="70" Enabled="false"></asp:TextBox>
        </ItemTemplate>
        <FooterTemplate>
            <asp:TextBox ID="txtTotalPrice" runat="server" Width="70" dir="rtl" Enabled="false" />        
        </FooterTemplate>
      </asp:TemplateField>
    </Columns>
    <FooterStyle CssClass="ContentSmall" />
    <RowStyle CssClass="ContentSmall" />
    <HeaderStyle CssClass="ContentMedium" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" DeleteMethod="DeleteProductInCart"
        SelectMethod="GetCartDetails" TypeName="ShoppingCartTableAdapters.CartDetailsTableAdapter">
        <SelectParameters>
            <asp:QueryStringParameter Name="UserId" DefaultValue="01be2d91-f762-4847-bde2-c4457789ddb0" QueryStringField="UserId" /></SelectParameters>
        <DeleteParameters>
            <asp:Parameter Name="CartDetailsId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
    <br />
    <asp:Panel ID="pnlButtons" runat="server">
        <asp:Button ID="btnContinueShopping" runat="server" Text="Kontynuuj zakupy" OnClick="btnContinueShopping_Click" />
        <asp:Button ID="btnCheckOut" runat="server" Text="Kasa" OnClick="btnCheckOut_Click" />
    </asp:Panel>
</asp:Content>
