
<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="TrackOrder.aspx.cs" Inherits="TrackOrder" Title="Stan zamwie" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<asp:Panel ID="pnlOrder" runat="server">
<table cellpadding="3" class="Table" width="300">
<tr>
    <td><div class="ContentMedium">Wybierz identyfikator zamwienia: </div></td>
    <td align="left"><asp:DropDownList ID="OrderId" runat="server" DataSourceID="OrderDataSource" DataValueField="OrderId" DataTextField="OrderId" AutoPostBack="true"></asp:DropDownList></td>
</tr>
</table>
<asp:ObjectDataSource ID="OrderDataSource" runat="server" SelectMethod="GetOrderIds" TypeName="ShoppingCartTableAdapters.OrderTableAdapter">
        <SelectParameters>
            <asp:QueryStringParameter Name="UserId" DefaultValue="01be2d91-f762-4847-bde2-c4457789ddb0" QueryStringField="UserId" /></SelectParameters>
</asp:ObjectDataSource>
<h4>Stan zamwienia:</h4>
<asp:FormView ID="FormView1" runat="server" DataSourceID="FormViewDataSource" EnableViewState="false" CssClass="Table">
        <ItemTemplate>
        <table width="300">
            <tr>
                <td style="width:300px">
                    <div class="ContentMedium">Identyfikator: <%#Eval("OrderId") %></div><br />
                    <div class="ContentMedium">Data: <%#Eval("OrderDate") %></div><br />
                    <div class="ContentMedium">Stan: <%#Eval("OrderStatus") %></div><br />
                </td>
            </tr>
        </table>
        </ItemTemplate>
    </asp:FormView>
    <asp:ObjectDataSource ID="FormViewDataSource" runat="server" 
        SelectMethod="GetOrderDetails" TypeName="ShoppingCartTableAdapters.OrderTableAdapter">
        <SelectParameters>
            <asp:ControlParameter ControlID="OrderId" Name="OrderId" PropertyName="SelectedValue"
                Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <div class="ContentSmall">
    ** Uwagi: W tym systemie zamwienie moe by w jednym z trzech stanw. <br />
    1. Stan "Potwierdzone" oznacza, e zamwienie zostao zoone.<br />
    2. Stan "Wysane" oznacza, e towar opuci magazyn, a wic jest w drodze.<br />
    3. Stan "Dostarczone" oznacza, e przesyka dotara do odbiorcy.
    </div>
    <h4>
        Szczegy zamwienia</h4>
    <asp:GridView ID="gvCart" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="CartDetailsId" AutoGenerateColumns="False" SelectedIndex="0" OnRowDataBound="gvCart_RowDataBound" HeaderStyle-CssClass="ContentMedium" 
    RowStyle-CssClass="ContentSmall" FooterStyle-CssClass="ContentSmall" ShowFooter="True" CellPadding="5">
    <Columns>
      <asp:TemplateField>
        <ItemTemplate>
            <asp:TextBox ID="CartDetailsId" runat="server" Text='<%# Eval("CartDetailsId") %>' Width="30" Visible="false"></asp:TextBox>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="ProductId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="ProductId" />
      <asp:BoundField DataField="ProductName" HeaderText="Nazwa" SortExpression="ProductName" />
      <asp:TemplateField HeaderText="Liczba">
        <ItemTemplate>
            <asp:Label ID="Quantity" runat="server" Text='<%# Eval("QuantityOrdered") %>' Width="30"></asp:Label>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena jednostkowa">
        <ItemTemplate>
            <asp:Label ID="UnitPrice" runat="server" Text='<%# Eval("UnitPrice") %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="lblSubTotal" runat="server" Text="Suma porednia: "></asp:Label><br />
            <asp:Label ID="lblTax" runat="server" Text="Podatek: "></asp:Label><br />
            <asp:Label ID="lblDiscount" runat="server" Text="Rabat: "></asp:Label><br />
            <asp:Label ID="lblShippingCharges" runat="server" Text="Opata za przesyk: "></asp:Label><br /><br />
            <asp:Label ID="lblTotalAmount" runat="server" Text="Suma cakowita: "></asp:Label>
        </FooterTemplate>
          <ItemStyle HorizontalAlign="Right" />
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Cena">
        <ItemTemplate>
            <asp:Label ID="Price" runat="server" Text='<%# Eval("Price") %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="SubTotal" runat="server" Width="70" dir="rtl"/><br />
            <asp:Label ID="Tax" runat="server" Width="70" dir="rtl" Text="30.00"/><br />
            <asp:Label ID="Discount" runat="server" Width="70" dir="rtl" Text="5.00"/><br />
            <asp:Label ID="ShippingCharges" runat="server" Width="70" dir="rtl" Text="15.00"/><br /><br />
            <asp:Label ID="TotalAmount" runat="server" Width="70" dir="rtl"/>
        </FooterTemplate>
          <ItemStyle HorizontalAlign="Right" />
      </asp:TemplateField>
    </Columns>
        <FooterStyle CssClass="ContentSmall" />
        <RowStyle CssClass="ContentSmall" />
        <HeaderStyle CssClass="ContentMedium" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" 
        SelectMethod="GetCartDetailsByOrderId" TypeName="ShoppingCartTableAdapters.CartDetailsTableAdapter">
        <SelectParameters>
            <asp:ControlParameter ControlID="OrderId" Name="OrderId" PropertyName="SelectedValue"
                Type="Int32" /></SelectParameters>
    </asp:ObjectDataSource>
 </asp:Panel>
 </asp:Content>