<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="OrderHistory.aspx.cs" Inherits="OrderHistory" Title="Order History" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<asp:Panel ID="pnlMain" runat="server">
    <div class="ContentSmall">
        W historii zamwienia mona przeledzi fazy jego realizacji po zoeniu przez klienta.<br />
        Na stronie tej znajduj si tylko te zamwienia, ktre zostay wysane.<br />
        Wywietla dat zamwienia, dat wysania oraz dat dostarczenia towaru do klienta.<br />
        Informacje te s przydatne w ledzeniu zamwie.
    </div><br /><br />
    <asp:GridView ID="gvOrderHistory" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="OrderId" AllowSorting="True" AutoGenerateColumns="False"
    SelectedIndex="0" OnSelectedIndexChanged="gvOrderHistory_SelectedIndexChanged" 
    OnPageIndexChanged="gvOrderHistory_PageIndexChanged" RowStyle-CssClass="ContentSmall"
    OnSorted="gvOrderHistory_Sorted" OnRowDataBound="gvOrderHistory_OnRowDataBound">
    <Columns>
      <asp:CommandField ButtonType="Button" ShowSelectButton="True" SelectText="Szczegy" />
      <asp:BoundField DataField="OrderId" HeaderText="Identyfikator zam&#243;wienia" ReadOnly="True" SortExpression="OrderId" />
      <asp:BoundField DataField="OrderDate" HeaderText="Data zoenia" SortExpression="OrderDate" />
      <asp:BoundField DataField="DispatchDate" HeaderText="Data wysania" SortExpression="DispatchDate" />
      <asp:BoundField DataField="ShippedDate" HeaderText="Data dostarczenia" SortExpression="ShippedDate" />
      <asp:TemplateField HeaderText="Suma cakowita" SortExpression="TotalAmount">
        <ItemTemplate>
            <asp:Label ID="TotalAmount" runat="server"></asp:Label>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="UserName" HeaderText="Imi i nazwisko klienta" SortExpression="UserName" />
      <asp:TemplateField HeaderText="Adres klienta" SortExpression="City">
        <ItemTemplate>
            <asp:Label ID="CustomerAddress" runat="server"></asp:Label>
        </ItemTemplate>
      </asp:TemplateField>
    </Columns>
        <RowStyle CssClass="ContentSmall" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" SelectMethod="GetOrderHistory" 
   TypeName="ShoppingCartTableAdapters.OrderHistoryTableAdapter">
    </asp:ObjectDataSource>
</asp:Panel>
<asp:Panel ID="pnlDetails" runat="server">
<h4>Szczegy zamwienia</h4>
    <asp:DetailsView AutoGenerateRows="False" DataSourceID="DetailsViewDataSource" DataKeyNames="OrderId" 
    CssClass="Table" ID="dvOrderStatus" RowStyle-CssClass="ContentSmall" runat="server" AutoGenerateEditButton="false" 
    OnModeChanging="dvOrderStatus_ModeChanging" Width="367px" EnableViewState="false">
    <Fields>
        <asp:TemplateField HeaderText="Order ID" SortExpression="OrderId">
            <ItemTemplate>
                <asp:Label ID="OrderId" runat="server" Text='<%# Bind("OrderId") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Order Status" SortExpression="OrderStatus">
            <ItemTemplate>
                <asp:Label ID="OrderStatus" runat="server" Text='<%# Bind("OrderStatus") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
    </Fields>
  </asp:DetailsView><br />
  <asp:ObjectDataSource ID="DetailsViewDataSource" runat="server" 
        OldValuesParameterFormatString="{0}" SelectMethod="GetOrderDetails"
        TypeName="ShoppingCartTableAdapters.OrderTableAdapter">
        <SelectParameters>
              <asp:ControlParameter ControlID="gvOrderHistory" Name="OrderId" PropertyName="SelectedValue"
                Type="Int32" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="OrderId" Type="Int32" />
        </UpdateParameters>
    </asp:ObjectDataSource>
    <asp:GridView ID="gvCart" runat="server" CssClass="Table" DataSourceID="GridViewDataSource1" 
    DataKeyNames="CartDetailsId" AutoGenerateColumns="false" SelectedIndex="0" OnRowDataBound="gvCart_RowDataBound" HeaderStyle-CssClass="ContentMedium" 
    RowStyle-CssClass="ContentSmall" FooterStyle-CssClass="ContentSmall" ShowFooter="true" CellPadding="5">
    <Columns>
      <asp:TemplateField>
        <ItemTemplate>
            <asp:TextBox ID="CartDetailsId" runat="server" Text='<%# Eval("CartDetailsId") %>' Width="30" Visible="false"></asp:TextBox>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="ProductId" HeaderText="Product ID" ReadOnly="True" SortExpression="ProductId" />
      <asp:BoundField DataField="ProductName" HeaderText="Product Name" SortExpression="ProductName" />
      <asp:TemplateField HeaderText="Quantity">
        <ItemTemplate>
            <asp:Label ID="Quantity" runat="server" Text='<%# Eval("QuantityOrdered") %>' Width="30"></asp:Label>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Unit Price" ItemStyle-HorizontalAlign="Right">
        <ItemTemplate>
            <asp:Label ID="UnitPrice" runat="server" Text='<%# String.Format("{0:##.00}", Eval("UnitPrice")) %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="lblSubTotal" runat="server" Text="Sub Total : "></asp:Label><br />
            <asp:Label ID="lblTax" runat="server" Text="Tax : "></asp:Label><br />
            <asp:Label ID="lblDiscount" runat="server" Text="Discount : "></asp:Label><br />
            <asp:Label ID="lblShippingCharges" runat="server" Text="Shipping & Handling Charges : "></asp:Label><br /><br />
            <asp:Label ID="lblTotalAmount" runat="server" Text="Total Amount (in US$) : "></asp:Label>
        </FooterTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="Price" ItemStyle-HorizontalAlign="Right">
        <ItemTemplate>
            <asp:Label ID="Price" runat="server" Text='<%# String.Format("{0:##.00}", Eval("Price")) %>' Width="70"></asp:Label>
        </ItemTemplate>
        <FooterTemplate>
            <asp:Label ID="SubTotal" runat="server" Width="70" dir="rtl"/><br />
            <asp:Label ID="Tax" runat="server" Width="70" dir="rtl" Text="30.00"/><br />
            <asp:Label ID="Discount" runat="server" Width="70" dir="rtl" Text="5.00"/><br />
            <asp:Label ID="ShippingCharges" runat="server" Width="70" dir="rtl" Text="15.00"/><br /><br />
            <asp:Label ID="TotalAmount" runat="server" Width="70" dir="rtl"/>
        </FooterTemplate>
      </asp:TemplateField>
    </Columns>
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource1" runat="server" 
        SelectMethod="GetCartDetailsByOrderId" TypeName="ShoppingCartTableAdapters.CartDetailsTableAdapter">
        <SelectParameters>
            <asp:ControlParameter ControlID="gvOrderHistory" Name="OrderId" PropertyName="SelectedValue"
                Type="Int32" /></SelectParameters>
    </asp:ObjectDataSource>
    <asp:Button ID="btnBack" runat="server" Text="Powrt" OnClick="btnBack_Click" /></asp:Panel>
</asp:Content>