<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="ManageProducts.aspx.cs" Inherits="ManageProducts" Title="Zarzdzanie produktami" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<asp:Panel ID="pnlMain" runat="server">
    <asp:Button ID="btnAddNew" runat="server" Text="Dodaj nowy produkt" OnClick="btnAddNew_Click" /><br />
    <asp:GridView ID="gvProducts" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="ProductId" AllowSorting="True" AutoGenerateColumns="False" RowStyle-CssClass="ContentSmall"
    SelectedIndex="0" OnSelectedIndexChanged="gvProducts_SelectedIndexChanged" 
    OnPageIndexChanged="gvProducts_PageIndexChanged" OnRowDeleted="gvProducts_RowDeleted" 
    OnSorted="gvProducts_Sorted" OnRowDataBound="gvProducts_OnRowDataBound">
    <Columns>
      <asp:CommandField ButtonType="Button" ShowSelectButton="True" ShowDeleteButton="True" DeleteText="Usu" SelectText="Wybierz" />
      <asp:BoundField DataField="ProductId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="ProductId" />
      <asp:TemplateField>
        <ItemTemplate>
            <img src="ImageHandler.ashx?ImageId=<%# Eval("ImageId") %>" alt='<%# Eval("ImageName") %>' /> 
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="ProductName" HeaderText="Nazwa" SortExpression="ProductName" />
      <asp:BoundField DataField="Description" HeaderText="Opis" SortExpression="Description" />
      <asp:BoundField DataField="CategoryId" HeaderText="Category ID" SortExpression="CategoryId" Visible="False" />
      <asp:BoundField DataField="CategoryName" HeaderText="Nazwa kategorii" SortExpression="CategoryName" />
      <asp:BoundField DataField="QuantityInStock" HeaderText="Zapasy" SortExpression="QuantityInStock" />
      <asp:BoundField DataField="ReorderLevel" HeaderText="Poziom ponownego zam&#243;wienia" SortExpression="ReorderLevel" />
      <asp:BoundField DataField="CostPrice" HeaderText="Koszt" SortExpression="CostPrice" />
      <asp:BoundField DataField="SellingPrice" HeaderText="Cena sprzeday" SortExpression="SellingPrice" />
    </Columns>
        <RowStyle CssClass="ContentSmall" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" DeleteMethod="DeleteProduct"
        SelectMethod="GetAllProducts" TypeName="ShoppingCartTableAdapters.ProductsTableAdapter">
        <DeleteParameters>
            <asp:Parameter Name="ProductId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<asp:Panel ID="pnlDetails" runat="server">
<asp:DetailsView AutoGenerateRows="False" DataSourceID="DetailsViewDataSource" DataKeyNames="ProductId" 
    CssClass="Table" HeaderText="Szczegy" RowStyle-CssClass="ContentSmall" ID="dvProduct" runat="server" AutoGenerateEditButton="True" 
    AutoGenerateInsertButton="True" OnItemInserted="dvProduct_ItemInserted" OnItemUpdated="dvProduct_ItemUpdated"
    OnDataBound="dvProduct_DataBound" OnModeChanging="dvProduct_ModeChanging" Width="367px" EnableViewState="False">
    <Fields>
        <asp:TemplateField HeaderText="Nazwa" SortExpression="ProductName">
            <EditItemTemplate>
                <asp:TextBox ID="EditProductName" runat="server" Text='<%# Bind("ProductName") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditProductName" ErrorMessage="Podaj nazw produktu."
                       ID="ProductNameRequired" runat="server" ToolTip="Podaj nazw produktu.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender2" runat="server" TargetControlID="ProductNameRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertProductName" runat="server" Text='<%# Bind("ProductName") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertProductName" ErrorMessage="Podaj nazw produktu."
                       ID="ProductNameRequired" runat="server" ToolTip="Podaj nazw produktu.">*</asp:RequiredFieldValidator>
                <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender1" runat="server" TargetControlID="ProductNameRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label1" runat="server" Text='<%# Bind("ProductName") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Opis" SortExpression="Description">
            <EditItemTemplate>
                <asp:TextBox ID="EditDescription" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditDescription" ErrorMessage="Podaj opis."
                       ID="DescriptionRequired" runat="server" ToolTip="Podaj opis.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender4" runat="server" TargetControlID="DescriptionRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertDescription" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertDescription" ErrorMessage="Podaj opis."
                       ID="DescriptionRequired" runat="server" ToolTip="Podaj opis.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender3" runat="server" TargetControlID="DescriptionRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("Description") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Kategoria" SortExpression="CategoryName">
            <EditItemTemplate>
                <asp:DropDownList ID="EditCategory" runat="server" DataSourceID="CategoryDataSource" DataValueField="CategoryId" DataTextField="CategoryName" SelectedValue='<%# Bind("CategoryId") %>'></asp:DropDownList>
                <asp:ObjectDataSource ID="CategoryDataSource" runat="server" SelectMethod="GetAllCategories" TypeName="ShoppingCartTableAdapters.CategoriesTableAdapter">
                </asp:ObjectDataSource>
                <asp:RequiredFieldValidator ControlToValidate="EditCategory" ErrorMessage="Podaj kategori."
                       ID="CategoryRequired" runat="server" ToolTip="Podaj kategori.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender8" runat="server" TargetControlID="CategoryRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:DropDownList ID="InsertCategory" runat="server" DataSourceID="CategoryDataSource" DataValueField="CategoryId" DataTextField="CategoryName"></asp:DropDownList>
                <asp:ObjectDataSource ID="CategoryDataSource" runat="server" SelectMethod="GetAllCategories" TypeName="ShoppingCartTableAdapters.CategoriesTableAdapter">
                </asp:ObjectDataSource>
                <asp:RequiredFieldValidator ControlToValidate="InsertCategory" ErrorMessage="Podaj kategori."
                       ID="CategoryRequired" runat="server" ToolTip="Podaj kategori.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender7" runat="server" TargetControlID="CategoryRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("CategoryName") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Zapasy" SortExpression="QuantityInStock">
            <EditItemTemplate>
                <asp:TextBox ID="EditQuantityInStock" runat="server" Text='<%# Bind("QuantityInStock") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditQuantityInStock" ErrorMessage="Podaj stan zapasw."
                       ID="QuantityInStockRequired" runat="server" ToolTip="Podaj stan zapasw.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender10" runat="server" TargetControlID="QuantityInStockRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Integer" ControlToValidate="EditQuantityInStock"
                      Display="Dynamic" ErrorMessage="Enter only numeric values."
                      ID="QuantityInStockCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertQuantityInStock" runat="server" Text='<%# Bind("QuantityInStock") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertQuantityInStock" ErrorMessage="Podaj stan zapasw."
                       ID="QuantityInStockRequired" runat="server" ToolTip="Podaj stan zapasw.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender9" runat="server" TargetControlID="QuantityInStockRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Integer" ControlToValidate="InsertQuantityInStock"
                      Display="Dynamic" ErrorMessage="Enter only numeric values."
                      ID="QuantityInStockCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("QuantityInStock") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Poziom ponownego zam&#243;wienia" SortExpression="ReorderLevel">
            <EditItemTemplate>
                <asp:TextBox ID="EditReorderLevel" runat="server" Text='<%# Bind("ReorderLevel") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditReorderLevel" ErrorMessage="Podaj poziom ponownego zamwienia."
                       ID="ReorderLevelRequired" runat="server" ToolTip="RPodaj poziom ponownego zamwienia.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender12" runat="server" TargetControlID="ReorderLevelRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Integer" ControlToValidate="EditReorderLevel"
                      Display="Dynamic" ErrorMessage="Enter only numeric values."
                      ID="ReorderLevelCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertReorderLevel" runat="server" Text='<%# Bind("ReorderLevel") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertReorderLevel" ErrorMessage="Podaj poziom ponownego zamwienia."
                       ID="ReorderLevelRequired" runat="server" ToolTip="Podaj poziom ponownego zamwienia.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender11" runat="server" TargetControlID="ReorderLevelRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Integer" ControlToValidate="InsertReorderLevel"
                      Display="Dynamic" ErrorMessage="Enter only numeric values."
                      ID="ReorderLevelCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("ReorderLevel") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Koszt" SortExpression="CostPrice">
            <EditItemTemplate>
                <asp:TextBox ID="EditCostPrice" runat="server" Text='<%# Bind("CostPrice") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditCostPrice" ErrorMessage="Podaj koszt."
                       ID="CostPriceRequired" runat="server" ToolTip="Podaj koszt.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender14" runat="server" TargetControlID="CostPriceRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Double" ControlToValidate="EditCostPrice"
                      Display="Dynamic" ErrorMessage="Enter only numeric/decimal values."
                      ID="CostPriceCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertCostPrice" runat="server" Text='<%# Bind("CostPrice") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertCostPrice" ErrorMessage="Podaj koszt."
                       ID="CostPriceRequired" runat="server" ToolTip="Podaj koszt.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender13" runat="server" TargetControlID="CostPriceRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Double" ControlToValidate="InsertCostPrice"
                      Display="Dynamic" ErrorMessage="Enter only numeric/decimal values."
                      ID="CostPriceCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("CostPrice") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Cena sprzeday" SortExpression="SellingPrice">
            <EditItemTemplate>
                <asp:TextBox ID="EditSellingPrice" runat="server" Text='<%# Bind("SellingPrice") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditSellingPrice" ErrorMessage="Selling Price is required."
                       ID="SellingPriceRequired" runat="server" ToolTip="Selling Price is required.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender16" runat="server" TargetControlID="SellingPriceRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Double" ControlToValidate="EditSellingPrice"
                      Display="Dynamic" ErrorMessage="Enter only numeric/decimal values."
                      ID="SellingPriceCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertSellingPrice" runat="server" Text='<%# Bind("SellingPrice") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertSellingPrice" ErrorMessage="Selling Price is required."
                       ID="SellingPriceRequired" runat="server" ToolTip="Selling Price is required.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender15" runat="server" TargetControlID="SellingPriceRequired">
                      </cc1:ValidatorCalloutExtender>
                <asp:CompareValidator Type="Double" ControlToValidate="InsertSellingPrice"
                      Display="Dynamic" ErrorMessage="Enter only numeric/decimal values."
                      ID="SellingPriceCompare" runat="server" Operator="DataTypeCheck"></asp:CompareValidator>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("SellingPrice") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Obraz">
            <EditItemTemplate>
                <asp:DropDownList ID="EditImage" runat="server" DataSourceID="ImageDataSource" DataValueField="ImageId" DataTextField="ImageName" SelectedValue='<%# Bind("ImageId") %>'></asp:DropDownList>
                <asp:ObjectDataSource ID="ImageDataSource" runat="server" SelectMethod="GetAllImages" TypeName="ShoppingCartTableAdapters.ImagesTableAdapter">
                </asp:ObjectDataSource>
                <asp:RequiredFieldValidator ControlToValidate="EditImage" ErrorMessage="Image is required."
                       ID="ImageRequired" runat="server" ToolTip="Image is required.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender6" runat="server" TargetControlID="ImageRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:DropDownList ID="InsertImage" runat="server" DataSourceID="ImageDataSource" DataValueField="ImageId" DataTextField="ImageName"></asp:DropDownList>
                <asp:ObjectDataSource ID="ImageDataSource" runat="server" SelectMethod="GetAllImages" TypeName="ShoppingCartTableAdapters.ImagesTableAdapter">
                </asp:ObjectDataSource>
                <asp:RequiredFieldValidator ControlToValidate="InsertImage" ErrorMessage="Image is required."
                       ID="ImageRequired" runat="server" ToolTip="Image is required.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender5" runat="server" TargetControlID="ImageRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("ImageName") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Uwagi" SortExpression="Notes">
            <EditItemTemplate>
                <asp:TextBox ID="EditNotes" runat="server" Text='<%# Bind("Notes") %>' TextMode="MultiLine" Rows="3"></asp:TextBox>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertNotes" runat="server" Text='<%# Bind("Notes") %>' TextMode="MultiLine" Rows="3"></asp:TextBox>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("Notes") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
    </Fields>
    <RowStyle CssClass="ContentSmall" />
  </asp:DetailsView><br />
  <asp:ObjectDataSource ID="DetailsViewDataSource" runat="server" DeleteMethod="DeleteProduct"
        InsertMethod="InsertProduct" OldValuesParameterFormatString="{0}" SelectMethod="GetProductById"
        TypeName="ShoppingCartTableAdapters.ProductsTableAdapter" UpdateMethod="UpdateProduct" 
        OnInserting="DetailsViewDataSource_Inserting" OnUpdating="DetailsViewDataSource_Updating">
        <SelectParameters>
              <asp:ControlParameter ControlID="gvProducts" Name="ProductId" PropertyName="SelectedValue"
                Type="Int32" />
            </SelectParameters>
        <DeleteParameters>
            <asp:Parameter Name="ProductId" Type="Int32" />
        </DeleteParameters>
        <UpdateParameters>
            <asp:Parameter Name="ProductName" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="QuantityInStock" Type="Int32" />
            <asp:Parameter Name="ReorderLevel" Type="Int32" />
            <asp:Parameter Name="CostPrice" Type="Decimal" />
            <asp:Parameter Name="SellingPrice" Type="Decimal" />
            <asp:Parameter Name="Notes" Type="String" />
            <asp:Parameter Name="CategoryId" Type="Int32" />
            <asp:Parameter Name="ImageId" Type="Int32" />
            <asp:Parameter Name="ProductId" Type="Int32" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Name="ProductName" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="QuantityInStock" Type="Int32" />
            <asp:Parameter Name="ReorderLevel" Type="Int32" />
            <asp:Parameter Name="CostPrice" Type="Decimal" />
            <asp:Parameter Name="SellingPrice" Type="Decimal" />
            <asp:Parameter Name="Notes" Type="String" />
        </InsertParameters>
    </asp:ObjectDataSource>
</asp:Panel>
</asp:Content>