using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;

public partial class ManageCategories : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Page.User.Identity.IsAuthenticated == false)
            Response.Redirect("Default.aspx");
        else
        {
            if (!Page.IsPostBack)
            {
                if (Page.User.IsInRole("Administrator") || Page.User.IsInRole("Manager"))
                {
                    this.Master.PageSubHeading.Text = ">> Zarzdzaj kategoriami";
                    this.pnlMain.Visible = true;
                    this.pnlDetails.Visible = false;
                    //this.GetCategories();
                }
            }
        }
    }

    private void GetCategories()
    {
        CategoriesTableAdapter CategoriesAdapter = new CategoriesTableAdapter();
        ShoppingCart.CategoriesDataTable Categories;
        Categories = CategoriesAdapter.GetAllCategories();
        gvCategories.DataSource = Categories;
        gvCategories.DataBind();
    }

    protected void btnAddNew_Click(object sender, EventArgs e)
    {
        this.pnlMain.Visible = false;
        this.pnlDetails.Visible = true;
        this.dvCategory.ChangeMode(DetailsViewMode.Insert);
    }

    protected void gvCategories_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.pnlMain.Visible = false;
        this.pnlDetails.Visible = true;
        dvCategory.ChangeMode(DetailsViewMode.Edit);
    }

    protected void gvCategories_PageIndexChanged(object sender, EventArgs e)
    {
        dvCategory.ChangeMode(DetailsViewMode.ReadOnly);
    }

    protected void gvCategories_Sorted(object sender, EventArgs e)
    {
        dvCategory.ChangeMode(DetailsViewMode.ReadOnly);
    }

    protected void gvCategories_RowDeleted(object sender, GridViewDeletedEventArgs e)
    {
        if (e.Exception != null)
        {
            this.Master.ErrorMessage.Text = "Usuwanie nie powiodo si.";
            e.ExceptionHandled = true;
        }
    }

    protected void gvCategories_OnRowDataBound(object sender, GridViewRowEventArgs e)
    {
        //if (e.Row.RowType == DataControlRowType.DataRow)
        //{
        //    if (e.Row.Cells[0].Controls[0] != null)
        //        ((Button)e.Row.Cells[0].Controls[0]).Attributes.Add("onclick", "return confirm('Are you sure you want to delete this record ?')");
        //}
    }

    protected void dvCategory_ItemInserted(Object sender, System.Web.UI.WebControls.DetailsViewInsertedEventArgs e)
    {
        if (e.Exception != null)
        {
            //Response.Write(e.Exception.Message + ". " + e.Exception.InnerException + ". " + e.Exception.StackTrace);
            this.Master.ErrorMessage.Text = "Podczas wprowadzania tego rekordu wystpi bd. Sprawd czy wprowadzasz poprawne dane.";
            e.ExceptionHandled = true;
        }
        //this.GetCategories();
        this.gvCategories.DataBind();
        this.pnlMain.Visible = true;
        this.pnlDetails.Visible = false;
    }

    protected void dvCategory_ItemUpdated(Object sender, System.Web.UI.WebControls.DetailsViewUpdatedEventArgs e)
    {
        //this.GetCategories();
        this.gvCategories.DataBind();
        this.pnlMain.Visible = true;
        this.pnlDetails.Visible = false;
    }

    protected void dvCategory_DataBound(object sender, EventArgs e)
    {
        if (dvCategory.CurrentMode == DetailsViewMode.Insert)
        {
            //dvCategory.Rows[0].Visible = false;
        }
    }

    protected void dvCategory_ModeChanging(Object sender, System.Web.UI.WebControls.DetailsViewModeEventArgs e)
    {
        if (e.CancelingEdit)
        {
            this.pnlMain.Visible = true;
            this.pnlDetails.Visible = false;
        }
    }

    
}
