<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="ManageCategories.aspx.cs" Inherits="ManageCategories" Title="Zarzdzanie kategoriami" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<asp:Panel ID="pnlMain" runat="server">
    <asp:Button ID="btnAddNew" runat="server" Text="Dodaj now kategori" OnClick="btnAddNew_Click" /><br />
    <asp:GridView ID="gvCategories" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="CategoryId" AllowSorting="true" AutoGenerateColumns="false"
    SelectedIndex="0" OnSelectedIndexChanged="gvCategories_SelectedIndexChanged" RowStyle-CssClass="ContentSmall"
    OnPageIndexChanged="gvCategories_PageIndexChanged" OnRowDeleted="gvCategories_RowDeleted" 
    OnSorted="gvCategories_Sorted" OnRowDataBound="gvCategories_OnRowDataBound">
    <Columns>
      <asp:CommandField ButtonType="Button" ShowSelectButton="true" ShowDeleteButton="true" DeleteText="Usu" SelectText="Wybierz" />
      <asp:BoundField DataField="CategoryId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="CategoryId" />
      <asp:BoundField DataField="CategoryName" HeaderText="Nazwa" SortExpression="CategoryName" />
      <asp:BoundField DataField="Description" HeaderText="Opis" SortExpression="Description" />
    </Columns>
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" DeleteMethod="Delete"
        SelectMethod="GetAllCategories" TypeName="ShoppingCartTableAdapters.CategoriesTableAdapter">
        <DeleteParameters>
            <asp:Parameter Name="CategoryId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<asp:Panel ID="pnlDetails" runat="server">
<asp:DetailsView AutoGenerateRows="False" DataSourceID="DetailsViewDataSource" DataKeyNames="CategoryId" 
    CssClass="Table" HeaderText="Szczegy" RowStyle-CssClass="ContentSmall" ID="dvCategory" runat="server" AutoGenerateEditButton="True" 
    AutoGenerateInsertButton="True" OnItemInserted="dvCategory_ItemInserted" OnItemUpdated="dvCategory_ItemUpdated"
    OnDataBound="dvCategory_DataBound" OnModeChanging="dvCategory_ModeChanging" Width="367px">
    <Fields>
        <asp:TemplateField HeaderText="Nazwa" SortExpression="CategoryName">
            <EditItemTemplate>
                <asp:TextBox ID="EditCategoryName" runat="server" Text='<%# Bind("CategoryName") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditCategoryName" ErrorMessage="Podaj nazw kategorii."
                       ID="CategoryNameRequired" runat="server" ToolTip="Podaj nazw kategorii.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender2" runat="server" TargetControlID="CategoryNameRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertCategoryName" runat="server" Text='<%# Bind("CategoryName") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertCategoryName" ErrorMessage="Podaj nazw kategorii."
                       ID="CategoryNameRequired" runat="server" ToolTip="Podaj nazw kategorii.">*</asp:RequiredFieldValidator>
                <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender1" runat="server" TargetControlID="CategoryNameRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label1" runat="server" Text='<%# Bind("CategoryName") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Opis" SortExpression="Description">
            <EditItemTemplate>
                <asp:TextBox ID="EditDescription" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditDescription" ErrorMessage="Podaj opis."
                       ID="DescriptionRequired" runat="server" ToolTip="Podaj opis kategorii.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender4" runat="server" TargetControlID="DescriptionRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertDescription" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertDescription" ErrorMessage="Podaj opis."
                       ID="DescriptionRequired" runat="server" ToolTip="Podaj opis kategorii.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender3" runat="server" TargetControlID="DescriptionRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label2" runat="server" Text='<%# Bind("Description") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
    </Fields>
    <RowStyle CssClass="ContentSmall" />
  </asp:DetailsView><br />
  <asp:ObjectDataSource ID="DetailsViewDataSource" runat="server" DeleteMethod="Delete"
        InsertMethod="Insert" OldValuesParameterFormatString="{0}" SelectMethod="GetCategoryById"
        TypeName="ShoppingCartTableAdapters.CategoriesTableAdapter" UpdateMethod="Update">
        <SelectParameters>
              <asp:ControlParameter ControlID="gvCategories" Name="CategoryId" PropertyName="SelectedValue"
                Type="Int32" />
            </SelectParameters>
        <DeleteParameters>
            <asp:Parameter Name="CategoryId" Type="Int32" />
        </DeleteParameters>
        <UpdateParameters>
            <asp:Parameter Name="CategoryName" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="CategoryId" Type="Int32" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Name="CategoryName" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
        </InsertParameters>
    </asp:ObjectDataSource>
</asp:Panel>
</asp:Content>