using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Page.User.Identity.IsAuthenticated)
        {
            if (Page.User.IsInRole("Administrator") || Page.User.IsInRole("Manager"))
                Response.Redirect("AdminHome.aspx");
        }
        Master.SearchClick += new MasterPage.SearchClickHandler(Master_SearchClick);
        this.Master.PageSubHeading.Text = ">> Jeste na stronie gwnej!";
        this.LoadProducts();
    }
    
    // Zdarzenie subskrybujce zdarzenie wygenerowane w stronie wzorcowej wyszukiwania produktw.
    void Master_SearchClick(object sender, EventArgs e)
    {
        ProductsTableAdapter ProductsAdapter = new ProductsTableAdapter();
        ShoppingCart.ProductsDataTable Products;
        // Response.Write("Category Name : " + Master.CategoryName + ". Product Name : " + Master.ProductName);
        Products = ProductsAdapter.SearchProducts(Master.CategoryName, Master.ProductName);
        ProductDataList.DataSource = Products;
        ProductDataList.DataBind();
    }

    private void LoadProducts()
    {
        ProductsTableAdapter ProductsAdapter = new ProductsTableAdapter();
        ShoppingCart.ProductsDataTable Products;
        Products = ProductsAdapter.GetLatestProducts();
        ProductDataList.DataSource = Products;
        ProductDataList.DataBind();
    }
}