using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;
using System.Web.Services;

public partial class Cart : System.Web.UI.Page
{
    decimal totalPrice = 0;
    protected void Page_Load(object sender, EventArgs e)
    {
        this.Master.PageSubHeading.Text = ">> Koszyk z zakupami!";
        if (Page.User.Identity.IsAuthenticated)
        {
            if (gvCart.Rows.Count > 0)
            {
                this.lblNote.Visible = true;
                this.pnlButtons.Visible = true;
            }
            else
            {
                this.lblNote.Visible = false;
                this.pnlButtons.Visible = false;
                this.Master.ErrorMessage.Text = "Koszyk jest pusty. Dodaj do niego jakie produkty!";
            }
            if (!Page.User.IsInRole("Customer"))
                this.Master.ErrorMessage.Text = "Aby obejrze zawarto koszyka, musisz zalogowa si jako klient!";
        }
        else
        {
            this.Master.ErrorMessage.Text = "** Zaloguj si, aby zajrze do koszyka! **";
            this.lblNote.Visible = false;
            this.pnlButtons.Visible = false;
        }
    }

    protected void gvCart_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            totalPrice += decimal.Parse(((TextBox)e.Row.FindControl("Price")).Text);
            if (e.Row.FindControl("Quantity") != null)
                ((TextBox)e.Row.FindControl("Quantity")).Attributes.Add("onkeyup", "UpdatePrice(" + ((TextBox)e.Row.FindControl("Quantity")).ClientID + ", " + ((TextBox)e.Row.FindControl("Price")).ClientID + ", " + ((TextBox)e.Row.FindControl("Price")).Text + ", " + ((TextBox)e.Row.FindControl("CartDetailsId")).Text + ");");
        }
        if (e.Row.RowType == DataControlRowType.Footer)
        {
            ((TextBox)e.Row.FindControl("txtTotalPrice")).Text = totalPrice.ToString();
        }
    }
    protected void gvCart_RowDeleted(object sender, GridViewDeletedEventArgs e)
    {
        if (e.Exception != null)
        {
            this.Master.ErrorMessage.Text = "Usuwanie nie powiodo si.";
            e.ExceptionHandled = true;
        }
        if (gvCart.Rows.Count == 0)
        {
            this.lblNote.Visible = false;
            this.pnlButtons.Visible = false;
            this.Master.ErrorMessage.Text = "Koszyk jest pusty. Dodaj do niego jakie produkty!";
        }
    }
    protected void btnContinueShopping_Click(object sender, EventArgs e)
    {
        Response.Redirect("Products.aspx");
    }
    
    [WebMethod]
    public static void UpdateCart(int Quantity, decimal Price, int CartDetailsId)
    {
        CartDetailsTableAdapter CartDetailsAdapter = new CartDetailsTableAdapter();
        CartDetailsAdapter.UpdateProductInCart(Quantity, Price, DateTime.Now, CartDetailsId);
    }

    protected void btnCheckOut_Click(object sender, EventArgs e)
    {
        MembershipUser myObject = Membership.GetUser();
        Guid UserID = (Guid)myObject.ProviderUserKey;
        Response.Redirect("Order.aspx?UserId=" + UserID.ToString());                
    }
}
