using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;

public partial class Products : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            Master.SearchClick += new MasterPage.SearchClickHandler(Master_SearchClick);
            this.Master.PageSubHeading.Text = ">> Strona produktw!";
            this.BindCategories();
            this.LoadProducts();
        }
    }
    // To zdarzenie subskrybuje zdarzenie wygenerowane na stronie wzorcowej dla wyszukiwania produktw.
    void Master_SearchClick(object sender, EventArgs e)
    {
        ProductsTableAdapter ProductsAdapter = new ProductsTableAdapter();
        ShoppingCart.ProductsDataTable Products;
        // Response.Write("Category Name : " + Master.CategoryName + ". Product Name : " + Master.ProductName);
        Products = ProductsAdapter.SearchProducts(Master.CategoryName, Master.ProductName);
        ProductDataList.DataSource = Products;
        ProductDataList.DataBind();
    }
    private void BindCategories()
    {
        CategoriesTableAdapter CategoriesAdapter = new CategoriesTableAdapter();
        ShoppingCart.CategoriesDataTable Categories;
        Categories = CategoriesAdapter.GetAllCategories();
        ddlCategories.DataSource = Categories;
        ddlCategories.DataBind();
        this.ddlCategories.Items.Insert(0, new ListItem("Wszystkie kategorie", string.Empty));
    }
    private void LoadProducts()
    {
        ProductsTableAdapter ProductsAdapter = new ProductsTableAdapter();
        ShoppingCart.ProductsDataTable Products;
        Products = ProductsAdapter.GetAllProducts();
        ProductDataList.DataSource = Products;
        ProductDataList.DataBind();
    }
    protected void ddlCategories_SelectedIndexChanged(object sender, EventArgs e)
    {
        ProductsTableAdapter ProductsAdapter = new ProductsTableAdapter();
        ShoppingCart.ProductsDataTable Products;
        if (ddlCategories.SelectedValue !=  string.Empty)
            Products = ProductsAdapter.GetProductsByCategory(int.Parse(ddlCategories.SelectedValue));
        else
            Products = ProductsAdapter.GetAllProducts();
        ProductDataList.DataSource = Products;
        ProductDataList.DataBind();
    }
}
