using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class OrderHistory : System.Web.UI.Page
{
    decimal subTotal;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Page.User.Identity.IsAuthenticated == false)
            Response.Redirect("Default.aspx");
        else
        {
            if (!Page.IsPostBack)
            {
                if (Page.User.IsInRole("Administrator") || Page.User.IsInRole("Manager"))
                {
                    this.Master.PageSubHeading.Text = ">> View Order History !";
                    this.pnlMain.Visible = true;
                    this.pnlDetails.Visible = false;
                }
            }
        }
    }

    protected void gvOrderHistory_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.pnlMain.Visible = false;
        this.pnlDetails.Visible = true;
    }

    protected void gvOrderHistory_PageIndexChanged(object sender, EventArgs e)
    {
        
    }

    protected void gvOrderHistory_Sorted(object sender, EventArgs e)
    {
        
    }

    protected void gvOrderHistory_OnRowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            if (e.Row.FindControl("CustomerAddress") != null)
                ((Label)e.Row.FindControl("CustomerAddress")).Text = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "Address")) + ",<br />" + Convert.ToString(DataBinder.Eval(e.Row.DataItem, "City")) + ",<br />" + Convert.ToString(DataBinder.Eval(e.Row.DataItem, "State")) + ",<br />" + Convert.ToString(DataBinder.Eval(e.Row.DataItem, "Country")) + ",<br />" + Convert.ToString(DataBinder.Eval(e.Row.DataItem, "Zipcode")) + ",<br />Contact : " + Convert.ToString(DataBinder.Eval(e.Row.DataItem, "ContactNo"));
            if (e.Row.FindControl("TotalAmount") != null)
                ((Label)e.Row.FindControl("TotalAmount")).Text = String.Format("{0:##.00}", Convert.ToString(DataBinder.Eval(e.Row.DataItem, "TotalAmount")));
        }
    }

    protected void gvCart_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            subTotal += decimal.Parse(((Label)e.Row.FindControl("Price")).Text);
        }
        if (e.Row.RowType == DataControlRowType.Footer)
        {
            ((Label)e.Row.FindControl("SubTotal")).Text = String.Format("{0:##.00}", subTotal.ToString());
            ((Label)e.Row.FindControl("TotalAmount")).Text = String.Format("{0:##.00}", Convert.ToString(subTotal + decimal.Parse(((Label)e.Row.FindControl("Tax")).Text) - decimal.Parse(((Label)e.Row.FindControl("Discount")).Text) + decimal.Parse(((Label)e.Row.FindControl("ShippingCharges")).Text)));
        }
    }

    protected void dvOrderStatus_ModeChanging(Object sender, System.Web.UI.WebControls.DetailsViewModeEventArgs e)
    {
        if (e.CancelingEdit)
        {
            this.pnlMain.Visible = true;
            this.pnlDetails.Visible = false;
        }
    }

    protected void btnBack_Click(object sender, EventArgs e)
    {
        Response.Redirect("OrderHistory.aspx");
    }
}
