using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;

public partial class Order : System.Web.UI.Page
{
    decimal subTotal = 0;
    static decimal tax;
    static decimal discount;
    static decimal shippingCharges;
    static decimal totalAmount;
    enum Operation
    {
        Add,
        Update
    }
    private static Operation AddressMode;
    protected void Page_Load(object sender, EventArgs e)
    {
        this.Master.PageSubHeading.Text = ">> Generowanie zamwie!";
        if (!Page.IsPostBack)
        {
            if (Page.User.Identity.IsAuthenticated)
            {
                if (!Page.User.IsInRole("Customer"))
                {
                    this.Master.ErrorMessage.Text = "Aby zoy zamwienie, musisz zalogowa si jako klient!";
                    this.pnlOrder.Visible = false;
                    this.pnlConfirm.Visible = false;
                }
                else
                {
                    if (gvCart.Rows.Count == 0)
                    {
                        this.Master.ErrorMessage.Text = "Koszyk jest pusty. Aby zoy zamwienie musisz doda co do koszyka!";
                        this.pnlOrder.Visible = false;
                        this.pnlConfirm.Visible = false;
                    }
                    else
                    {
                        this.pnlOrder.Visible = true;
                        this.pnlConfirm.Visible = false;
                        this.FillDates();
                        this.GetCustomerAddress();
                    }
                }
            }
            else
            {
                this.Master.ErrorMessage.Text = "** Aby kupi produkty musisz zalogowa si jako klient! **";
                this.pnlOrder.Visible = false;
                this.pnlConfirm.Visible = false;
            }
        }
    }

    private void GetCustomerAddress()
    {
        AddressTableAdapter AddressAdapter = new AddressTableAdapter();
        MembershipUser myObject = Membership.GetUser();
        Guid UserID = (Guid)myObject.ProviderUserKey;
        ShoppingCart.AddressDataTable AddressTable = AddressAdapter.GetCustomerAddress(UserID);
        if (AddressTable.Rows.Count == 0)
            AddressMode = Operation.Add;
        else
        {
            AddressMode = Operation.Update;
            AddressId.Text = AddressTable.Rows[0]["AddressId"].ToString();
            Address.Text = AddressTable.Rows[0]["Address"].ToString();
            City.Text = AddressTable.Rows[0]["City"].ToString();
            State.Text = AddressTable.Rows[0]["State"].ToString();
            Country.Text = AddressTable.Rows[0]["Country"].ToString();
            Zipcode.Text = AddressTable.Rows[0]["Zipcode"].ToString();
            ContactNo.Text = AddressTable.Rows[0]["ContactNo"].ToString();
        }
    }
    protected void gvCart_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            subTotal += decimal.Parse(((Label)e.Row.FindControl("Price")).Text);
        }
        if (e.Row.RowType == DataControlRowType.Footer)
        {
            ((Label)e.Row.FindControl("SubTotal")).Text = subTotal.ToString();
            ((Label)e.Row.FindControl("TotalAmount")).Text = Convert.ToString(subTotal + decimal.Parse(((Label)e.Row.FindControl("Tax")).Text.Replace('.', ',')) - decimal.Parse(((Label)e.Row.FindControl("Discount")).Text.Replace('.', ',')) + decimal.Parse(((Label)e.Row.FindControl("ShippingCharges")).Text.Replace('.', ',')));
            tax = decimal.Parse(((Label)e.Row.FindControl("Tax")).Text.Replace('.', ','));
            discount = decimal.Parse(((Label)e.Row.FindControl("Discount")).Text.Replace('.', ','));
            shippingCharges = decimal.Parse(((Label)e.Row.FindControl("ShippingCharges")).Text.Replace('.', ','));
            totalAmount = decimal.Parse(((Label)e.Row.FindControl("TotalAmount")).Text.Replace('.', ','));
        }
    }
    protected void btnPlaceOrder_Click(object sender, EventArgs e)
    {
        CartTableAdapter CartAdapter = new CartTableAdapter();
        MembershipUser myObject = Membership.GetUser();
        Guid UserID = (Guid)myObject.ProviderUserKey;
        ShoppingCart.CartDataTable CartTable = CartAdapter.IsCartExists(UserID);
        int CartId = 0;
        if (CartTable.Rows.Count > 0)
            CartId = int.Parse(CartTable.Rows[0]["CartId"].ToString());

        AddressTableAdapter AddressAdapter = new AddressTableAdapter();
        if (AddressMode == Operation.Add)
            AddressAdapter.Insert(UserID, Address.Text, City.Text, State.Text, Country.Text, Zipcode.Text, ContactNo.Text);
        else if (AddressMode == Operation.Update)
            AddressAdapter.Update(UserID, Address.Text, City.Text, State.Text, Country.Text, Zipcode.Text, ContactNo.Text, int.Parse(AddressId.Text));
        OrderTableAdapter OrderAdapter = new OrderTableAdapter();
        OrderAdapter.PlaceOrder(CartId, tax, discount, shippingCharges, totalAmount, "Confirmed");
        this.pnlOrder.Visible = false;
        this.pnlConfirm.Visible = true;
    }
    private void FillDates()
    {
        for (int year = 2008; year <= 2009; year++)
        {
            for (int month = 1; month <= 12; month++)
            {
                ExpiryDate.Items.Add(new ListItem(month.ToString() + "/" + year.ToString(), month.ToString() + "/" + year.ToString()));
            }
        }
    }
}
