using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;

public partial class MasterPage : System.Web.UI.MasterPage
{
    private string _categoryName;
    private string _productName;

    public string CategoryName
    {
        get { return _categoryName; }
        set { _categoryName = value; }
    }

    public string ProductName
    {
        get { return _productName; }
        set { _productName = value; }
    }

    public delegate void SearchClickHandler(object sender, System.EventArgs e);

    public event SearchClickHandler SearchClick;

    public Label PageSubHeading
    {
        get { return lblPageSubHeading; }
        set { lblPageSubHeading = value; }
    }
    public Label ErrorMessage
    {
        get { return lblErrorMessage; }
        set { lblErrorMessage = value; }
    }
    public enum SiteMapMenuType
    {
        Customer,
        Admin
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        this.lblTime.Text = DateTime.Now.ToString();
        //this.lblErrorMessage.Text = string.Empty;
        if (!Page.IsPostBack)
            this.BindCategories();
        if (Page.User.Identity.IsAuthenticated == false)
        {
            this.LoginStatus1.Visible = false;
            this.Menu1.DataSource = this.GetMenuDataSource(SiteMapMenuType.Customer);
            this.Menu1.DataBind();
        }
        else
        {
            this.LoginStatus1.Visible = true;
            if (Page.User.IsInRole("Customer"))
            {
                this.Menu1.DataSource = this.GetMenuDataSource(SiteMapMenuType.Customer);
                this.Menu1.DataBind();
                MembershipUser myObject = Membership.GetUser();
                if (this.Menu1.Items[2] != null && this.Menu1.Items[2].NavigateUrl == "~/Cart.aspx")
                    this.Menu1.Items[2].NavigateUrl = "~/Cart.aspx?UserId=" + myObject.ProviderUserKey.ToString();
                if (this.Menu1.Items[3] != null && this.Menu1.Items[3].NavigateUrl == "~/Order.aspx")
                    this.Menu1.Items[3].NavigateUrl = "~/Order.aspx?UserId=" + myObject.ProviderUserKey.ToString();
                if (this.Menu1.Items[4] != null && this.Menu1.Items[4].NavigateUrl == "~/TrackOrder.aspx")
                    this.Menu1.Items[4].NavigateUrl = "~/TrackOrder.aspx?UserId=" + myObject.ProviderUserKey.ToString();
            }
            else
            {
                this.Menu1.DataSource = this.GetMenuDataSource(SiteMapMenuType.Admin);
                this.Menu1.DataBind();
            }
        }
    }

    protected void LoginStatus1_LoggedOut(object sender, System.EventArgs e)
    {
        Response.Redirect("Default.aspx");
    }

    XmlDataSource GetMenuDataSource(SiteMapMenuType menu)
    {
        XmlDataSource source = new XmlDataSource();
        source.XPath = "siteMap/siteMapNode";
        switch (menu)
        {
            case SiteMapMenuType.Customer:
                source.DataFile = @"~\Customer.sitemap";
                break;
            case SiteMapMenuType.Admin:
                source.DataFile = @"~\Admin.sitemap";
                break;
            default:
                break;
        }
        source.DataBind();
        return source;
    }
    protected void btnSearchProduct_Click(object sender, EventArgs e)
    {
        if (ddlCategories.SelectedValue == string.Empty)
            CategoryName = string.Empty;
        else
            CategoryName = ddlCategories.SelectedItem.Text;
        ProductName = txtSearchProduct.Text.Trim();

        //Fire event to existing delegate
        OnSearchClick(e);
        //Response.Write(ddlCategories.SelectedItem.Text + "-" + txtSearchProduct.Text.Trim());
    }
    protected virtual void OnSearchClick(EventArgs e)
    {
        if (SearchClick != null)
        {
            //invokes the delegates
            SearchClick(this, e);
        }
    }

    private void BindCategories()
    {
        CategoriesTableAdapter CategoriesAdapter = new CategoriesTableAdapter();
        ShoppingCart.CategoriesDataTable Categories;
        Categories = CategoriesAdapter.GetAllCategories();
        ddlCategories.DataSource = Categories;
        ddlCategories.DataBind();
        this.ddlCategories.Items.Insert(0, new ListItem("Wszystkie kategorie", string.Empty));
    }
}
