using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;

public partial class ManageProducts : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Page.User.Identity.IsAuthenticated == false)
            Response.Redirect("Default.aspx");
        else
        {
            if (!Page.IsPostBack)
            {
                if (Page.User.IsInRole("Administrator") || Page.User.IsInRole("Manager"))
                {
                    this.Master.PageSubHeading.Text = ">> Zarzdzanie produktami";
                    this.pnlMain.Visible = true;
                    this.pnlDetails.Visible = false;
                }
            }
        }
    }

    protected void btnAddNew_Click(object sender, EventArgs e)
    {
        this.pnlMain.Visible = false;
        this.pnlDetails.Visible = true;
        this.dvProduct.ChangeMode(DetailsViewMode.Insert);
    }

    protected void gvProducts_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.pnlMain.Visible = false;
        this.pnlDetails.Visible = true;
        dvProduct.ChangeMode(DetailsViewMode.Edit);
    }

    protected void gvProducts_PageIndexChanged(object sender, EventArgs e)
    {
        dvProduct.ChangeMode(DetailsViewMode.ReadOnly);
    }

    protected void gvProducts_Sorted(object sender, EventArgs e)
    {
        dvProduct.ChangeMode(DetailsViewMode.ReadOnly);
    }

    protected void gvProducts_RowDeleted(object sender, GridViewDeletedEventArgs e)
    {
        if (e.Exception != null)
        {
            //Response.Write(e.Exception.Message + ". " + e.Exception.InnerException + ". " + e.Exception.StackTrace);
            this.Master.ErrorMessage.Text = "Usuwanie nie powiodo si.";
            e.ExceptionHandled = true;
        }
    }

    protected void gvProducts_OnRowDataBound(object sender, GridViewRowEventArgs e)
    {
        //if (e.Row.RowType == DataControlRowType.DataRow)
        //{
        //    if (e.Row.Cells[0].Controls[0] != null)
        //        ((Button)e.Row.Cells[0].Controls[0]).Attributes.Add("onclick", "return confirm('Are you sure you want to delete this record ?')");
        //}
    }

    protected void dvProduct_ItemInserted(Object sender, System.Web.UI.WebControls.DetailsViewInsertedEventArgs e)
    {
        if (e.Exception != null)
        {
            Response.Write(e.Exception.Message + ". " + e.Exception.InnerException + ". " + e.Exception.StackTrace);
            this.Master.ErrorMessage.Text = "Podczas wprowadzania tego rekordu wystpi bd. Sprawd czy wprowadzasz poprawne dane.";
            e.ExceptionHandled = true;
        }
        this.gvProducts.DataBind();
        this.pnlMain.Visible = true;
        this.pnlDetails.Visible = false;
    }

    protected void dvProduct_ItemUpdated(Object sender, System.Web.UI.WebControls.DetailsViewUpdatedEventArgs e)
    {
        this.gvProducts.DataBind();
        this.pnlMain.Visible = true;
        this.pnlDetails.Visible = false;
    }

    protected void dvProduct_DataBound(object sender, EventArgs e)
    {
        if (dvProduct.CurrentMode == DetailsViewMode.Insert)
        {
            //dvProduct.Rows[0].Visible = false;
        }
    }

    protected void dvProduct_ModeChanging(Object sender, System.Web.UI.WebControls.DetailsViewModeEventArgs e)
    {
        if (e.CancelingEdit)
        {
            this.pnlMain.Visible = true;
            this.pnlDetails.Visible = false;
        }
    }

    protected void DetailsViewDataSource_Inserting(object sender, ObjectDataSourceMethodEventArgs e)
    {
        DropDownList categoryDropdown = (DropDownList)dvProduct.FindControl("InsertCategory"); ;
        DropDownList imageDropdown = (DropDownList)dvProduct.FindControl("InsertImage"); ;
        //Response.Write(categoryDropdown.SelectedValue + "-" + categoryDropdown.SelectedItem.Text);
        //Response.Write(imageDropdown.SelectedValue + "-" + imageDropdown.SelectedItem.Text);
        //Response.Write(e.InputParameters.Count);
        e.InputParameters.Add("CategoryId", categoryDropdown.SelectedValue);
        e.InputParameters.Add("ImageId", imageDropdown.SelectedValue);
    }

    protected void DetailsViewDataSource_Updating(object sender, ObjectDataSourceMethodEventArgs e)
    {
        DropDownList categoryDropdown = (DropDownList)dvProduct.FindControl("EditCategory"); ;
        DropDownList imageDropdown = (DropDownList)dvProduct.FindControl("EditImage"); ;
        //Response.Write(categoryDropdown.SelectedValue + "-" + categoryDropdown.SelectedItem.Text);
        //Response.Write(imageDropdown.SelectedValue + "-" + imageDropdown.SelectedItem.Text);
        //Response.Write(e.InputParameters.Count);
        e.InputParameters["CategoryId"] = categoryDropdown.SelectedValue;
        e.InputParameters["ImageId"] = imageDropdown.SelectedValue;
    }
}
