using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoppingCartTableAdapters;
using System.IO;

public partial class ManageImages : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Page.User.Identity.IsAuthenticated == false)
            Response.Redirect("Default.aspx");
        else
        {
            if (!Page.IsPostBack)
            {
                if (Page.User.IsInRole("Administrator") || Page.User.IsInRole("Manager"))
                {
                    this.Master.PageSubHeading.Text = ">> Zarzdzanie obrazami";
                    this.pnlMain.Visible = true;
                    this.pnlDetails.Visible = false;
                }
            }
        }
    }
    
    protected void btnAddNew_Click(object sender, EventArgs e)
    {
        this.pnlMain.Visible = false;
        this.pnlDetails.Visible = true;
        this.dvImage.ChangeMode(DetailsViewMode.Insert);
    }

    protected void gvImages_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.pnlMain.Visible = false;
        this.pnlDetails.Visible = true;
        dvImage.ChangeMode(DetailsViewMode.Edit);
    }

    protected void gvImages_PageIndexChanged(object sender, EventArgs e)
    {
        dvImage.ChangeMode(DetailsViewMode.ReadOnly);
    }

    protected void gvImages_Sorted(object sender, EventArgs e)
    {
        dvImage.ChangeMode(DetailsViewMode.ReadOnly);
    }

    protected void gvImages_RowDeleted(object sender, GridViewDeletedEventArgs e)
    {
        if (e.Exception != null)
        {
            //Response.Write(e.Exception.Message + ". " + e.Exception.InnerException + ". " + e.Exception.StackTrace);
            this.Master.ErrorMessage.Text = "usuwanie nie powiodo si.";
            e.ExceptionHandled = true;
        }
    }

    protected void gvImages_OnRowDataBound(object sender, GridViewRowEventArgs e)
    {
        //if (e.Row.RowType == DataControlRowType.DataRow)
        //{
        //    if (e.Row.Cells[0].Controls[0] != null)
        //        ((Button)e.Row.Cells[0].Controls[0]).Attributes.Add("onclick", "return confirm('Are you sure you want to delete this record ?')");
        //}
    }

    protected void dvImage_ItemInserted(Object sender, System.Web.UI.WebControls.DetailsViewInsertedEventArgs e)
    {
        if (e.Exception != null)
        {
            //Response.Write(e.Exception.Message + ". " + e.Exception.InnerException + ". " + e.Exception.StackTrace);
            this.Master.ErrorMessage.Text = "Podczas wprowadzania tego rekordu wystpi bd. Sprawd czy wprowadzasz poprawne dane.";
            e.ExceptionHandled = true;
        }
        this.gvImages.DataBind();
        this.pnlMain.Visible = true;
        this.pnlDetails.Visible = false;
    }

    protected void dvImage_ItemUpdated(Object sender, System.Web.UI.WebControls.DetailsViewUpdatedEventArgs e)
    {
        this.gvImages.DataBind();
        this.pnlMain.Visible = true;
        this.pnlDetails.Visible = false;
    }

    protected void dvImage_DataBound(object sender, EventArgs e)
    {
        if (dvImage.CurrentMode == DetailsViewMode.Insert)
        {
            //dvImage.Rows[0].Visible = false;
        }
    }

    protected void dvImage_ModeChanging(Object sender, System.Web.UI.WebControls.DetailsViewModeEventArgs e)
    {
        if (e.CancelingEdit)
        {
            this.pnlMain.Visible = true;
            this.pnlDetails.Visible = false;
        }
    }

    protected void DetailsViewDataSource_Inserting(object sender, ObjectDataSourceMethodEventArgs e)
    {
        FileUpload imageTextBox = (FileUpload)dvImage.FindControl("InsertImage");;
        string fileExtension = Path.GetExtension(imageTextBox.PostedFile.FileName).ToLower();
        string mType = string.Empty;
        switch (fileExtension)
        {
            case ".gif":
                mType = "image/gif";
                break;
            case ".jpg":
            case ".jpeg":
            case ".jpe":
                mType = "image/jpeg";
                break;
            case ".png":
                mType = "image/png";
                break;
        }
        if (mType == string.Empty)
        {
            e.Cancel = true;
            return;
        }
        System.IO.Stream inputStream = imageTextBox.PostedFile.InputStream;
        int imageLength = imageTextBox.PostedFile.ContentLength;
        byte[] imageBinary = new byte[imageLength];
        int inputRead = inputStream.Read(imageBinary, 0, imageLength);
        byte[] uploadData = imageBinary;
        e.InputParameters.Add("ImageData", uploadData);
        e.InputParameters.Add("MIMEType", mType);
    }

    protected void DetailsViewDataSource_Updating(object sender, ObjectDataSourceMethodEventArgs e)
    {
        FileUpload imageTextBox = (FileUpload)dvImage.FindControl("EditImage"); ;
        string fileExtension = Path.GetExtension(imageTextBox.PostedFile.FileName).ToLower();
        string mType = string.Empty;
        switch (fileExtension)
        {
            case ".gif":
                mType = "image/gif";
                break;
            case ".jpg":
            case ".jpeg":
            case ".jpe":
                mType = "image/jpeg";
                break;
            case ".png":
                mType = "image/png";
                break;
        }
        if (mType == string.Empty)
        {
            e.Cancel = true;
            return;
        }
        System.IO.Stream inputStream = imageTextBox.PostedFile.InputStream;
        int imageLength = imageTextBox.PostedFile.ContentLength;
        byte[] imageBinary = new byte[imageLength];
        int inputRead = inputStream.Read(imageBinary, 0, imageLength);
        byte[] uploadData = imageBinary;
        e.InputParameters.Add("ImageData", uploadData);
        e.InputParameters.Add("MIMEType", mType);
    }

}
