<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="ManageImages.aspx.cs" Inherits="ManageImages" Title="Zarzdzanie obrazami" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ MasterType TypeName="MasterPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<asp:Panel ID="pnlMain" runat="server">
    <asp:Button ID="btnAddNew" runat="server" Text="Dodaj nowy obraz" OnClick="btnAddNew_Click" /><br />
    <asp:GridView ID="gvImages" runat="server" CssClass="Table" DataSourceID="GridViewDataSource" 
    DataKeyNames="ImageId" AllowSorting="True" AutoGenerateColumns="False"
    SelectedIndex="0" OnSelectedIndexChanged="gvImages_SelectedIndexChanged" RowStyle-CssClass="ContentSmall"
    OnPageIndexChanged="gvImages_PageIndexChanged" OnRowDeleted="gvImages_RowDeleted" 
    OnSorted="gvImages_Sorted" OnRowDataBound="gvImages_OnRowDataBound">
    <Columns>
      <asp:CommandField ButtonType="Button" ShowSelectButton="True" ShowDeleteButton="True" CancelText="Anuluj" DeleteText="Usu" EditText="Edytuj" InsertText="Wstaw" NewText="Nowy" SelectText="Wybierz" UpdateText="Aktualizuj" />
      <asp:BoundField DataField="ImageId" HeaderText="Identyfikator" ReadOnly="True" SortExpression="ImageId" />
      <asp:BoundField DataField="ImageName" HeaderText="Nazwa" SortExpression="ImageName" />
      <asp:TemplateField>
        <ItemTemplate>
            <img src="ImageHandler.ashx?ImageId=<%# Eval("ImageId") %>" alt='<%# Eval("ImageName") %>' /> 
        </ItemTemplate>
      </asp:TemplateField>
      <asp:BoundField DataField="MIMEType" HeaderText="Typ MIME" SortExpression="MIMEType" />
    </Columns>
        <RowStyle CssClass="ContentSmall" />
    </asp:GridView><br />
  <asp:ObjectDataSource ID="GridViewDataSource" runat="server" DeleteMethod="Delete"
        SelectMethod="GetAllImages" TypeName="ShoppingCartTableAdapters.ImagesTableAdapter">
        <DeleteParameters>
            <asp:Parameter Name="ImageId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<asp:Panel ID="pnlDetails" runat="server">
<asp:DetailsView AutoGenerateRows="False" DataSourceID="DetailsViewDataSource" DataKeyNames="ImageId" 
    CssClass="Table" HeaderText="Szczegy" RowStyle-CssClass="ContentSmall" ID="dvImage" runat="server" AutoGenerateEditButton="True" 
    AutoGenerateInsertButton="True" OnItemInserted="dvImage_ItemInserted" OnItemUpdated="dvImage_ItemUpdated"
    OnDataBound="dvImage_DataBound" OnModeChanging="dvImage_ModeChanging" Width="545px">
    <Fields>
        <asp:TemplateField HeaderText="Nazwa" SortExpression="ImageName">
            <EditItemTemplate>
                <asp:TextBox ID="EditImageName" runat="server" Text='<%# Bind("ImageName") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="EditImageName" ErrorMessage="Podaj nazw obrazu."
                       ID="ImageNameRequired" runat="server" ToolTip="Podaj nazw obrazu.">*</asp:RequiredFieldValidator>
                      <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender2" runat="server" TargetControlID="ImageNameRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:TextBox ID="InsertImageName" runat="server" Text='<%# Bind("ImageName") %>'></asp:TextBox>
                <asp:RequiredFieldValidator ControlToValidate="InsertImageName" ErrorMessage="Podaj nazw obrazu."
                       ID="ImageNameRequired" runat="server" ToolTip="Image Name is required.">*</asp:RequiredFieldValidator>
                <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender1" runat="server" TargetControlID="ImageNameRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <asp:Label ID="Label1" runat="server" Text='<%# Bind("ImageName") %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="Obraz">
            <EditItemTemplate>
                <img src="ImageHandler.ashx?ImageId=<%# Eval("ImageId") %>" alt='<%# Eval("ImageName") %>' /> 
                <asp:FileUpload ID="EditImage" runat="server" />
                <asp:RequiredFieldValidator ControlToValidate="EditImage" ErrorMessage="Obraz jest wymagany."
                       ID="ImageRequired" runat="server" ToolTip="Obraz jest wymagany.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender4" runat="server" TargetControlID="ImageRequired">
                      </cc1:ValidatorCalloutExtender>
            </EditItemTemplate>
            <InsertItemTemplate>
                <asp:FileUpload ID="InsertImage" runat="server" />
                <asp:RequiredFieldValidator ControlToValidate="InsertImage" ErrorMessage="Obraz jest wymagany."
                       ID="ImageRequired" runat="server" ToolTip="Obraz jest wymagany.">*</asp:RequiredFieldValidator>
                       <cc1:ValidatorCalloutExtender ID="ValidatorCalloutExtender3" runat="server" TargetControlID="ImageRequired">
                      </cc1:ValidatorCalloutExtender>
            </InsertItemTemplate>
            <ItemTemplate>
                <img src="ImageHandler.ashx?ImageId=<%# Eval("ImageId") %>" alt='<%# Eval("ImageName") %>' /> 
            </ItemTemplate>
        </asp:TemplateField>
    </Fields>
    <RowStyle CssClass="ContentSmall" />
  </asp:DetailsView><br />
  <asp:ObjectDataSource ID="DetailsViewDataSource" runat="server" DeleteMethod="Delete"
        InsertMethod="Insert" OldValuesParameterFormatString="{0}" SelectMethod="GetImageById"
        TypeName="ShoppingCartTableAdapters.ImagesTableAdapter" UpdateMethod="Update"
         OnInserting="DetailsViewDataSource_Inserting" OnUpdating="DetailsViewDataSource_Updating">
        <SelectParameters>
              <asp:ControlParameter ControlID="gvImages" Name="ImageId" PropertyName="SelectedValue"
                Type="Int32" />
            </SelectParameters>
        <DeleteParameters>
            <asp:Parameter Name="ImageId" Type="Int32" />
        </DeleteParameters>
        <UpdateParameters>
            <asp:Parameter Name="ImageName" Type="String" />
            <asp:Parameter Name="ImageId" Type="Int32" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Name="ImageName" Type="String" />
        </InsertParameters>
    </asp:ObjectDataSource>
</asp:Panel>
</asp:Content>