<%@ WebHandler Language="C#" Class="ImageHandler" %>

using System;
using System.Web;
using System.IO;
using ShoppingCartTableAdapters;

public class ImageHandler : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) 
    {
        context.Response.ContentType = "image/jpeg";
        context.Response.Cache.SetCacheability(HttpCacheability.Public);
        context.Response.BufferOutput = false;
        Int32 ImageId = -1;
        Stream stream = null;
        ImageId = Convert.ToInt32(context.Request.QueryString["ImageId"]);
        stream = GetImage(ImageId);
        const int buffersize = 1024 * 16;
        byte[] bufferImage = new byte[buffersize];
        int count = stream.Read(bufferImage, 0, buffersize);
        while (count > 0)
        {
            context.Response.OutputStream.Write(bufferImage, 0, count);
            count = stream.Read(bufferImage, 0, buffersize);
        }

    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

    public static Stream GetImage(int ImageId)
    {
        ImagesTableAdapter ImagesAdapter = new ImagesTableAdapter(); ;
        ShoppingCart.ImagesDataTable Images;
        Images = ImagesAdapter.GetImageById(ImageId);
        object ImageData = Images.Rows[0]["ImageData"];
        try
        {
            return new MemoryStream((byte[])ImageData);
        }
        catch
        {
            return null;
        }
    }
}