using Amazon;

public class AWSECommerceServiceWrapper
{
  public Amazon.Items Search(string accessKey, string query)
  {
    ItemSearchRequest searchRequest = new ItemSearchRequest();
    searchRequest.Keywords = query;
    searchRequest.ResponseGroup = new string[] { "Small" };
    searchRequest.SearchIndex = "Books";

    ItemSearch search = new ItemSearch();
    search.AWSAccessKeyId = accessKey;
    search.Request = new ItemSearchRequest[1] { searchRequest };

    AWSECommerceService awse = new AWSECommerceService();
    ItemSearchResponse searchResponse = awse.ItemSearch(search);
    return searchResponse.Items[0];
  }

  public Amazon.Items SearchXslt(string accessKey, string query)
  {
    return Search(accessKey, query);
  }
}
