
Partial Class UserInfo
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim user As MembershipUser
        '---Pobierz informacje o biecym uytkowniku.
        user = Membership.GetUser
        Response.Write("Ostatni raz zalogowae si: " & _
              user.LastLoginDate & "<br/>")
        Response.Write("Twoje konto zostao utworzone: " & _
              user.CreationDate & "<br/>")
        Response.Write("Ostatni raz Twoje haso byo zmienione: " & _
              user.LastPasswordChangedDate & "<br/>")
        If Not IsPostBack Then
            txtUserID.Text = user.UserName.ToString
            txtPasswordQuestion.Text = user.PasswordQuestion
            txtEmail.Text = user.Email
        End If

    End Sub

    Private Sub displayMessage(ByVal str As String)
        Response.Write("<br/><b>" & str & "</b>")
    End Sub

    Protected Sub btnChangePassword_Click(ByVal sender As Object, _
      ByVal e As System.EventArgs) _
      Handles btnChangePassword.Click
        Dim user As MembershipUser = Membership.GetUser
        '==Zmie haso===
        If txtCurrentPassword.Text <> "" And _
           (txtNewPassword.Text <> txtCurrentPassword.Text) And _
           txtNewPassword.Text <> "" Then
            '---Oznacza, e uytkownik chce zmieni haso.
            If user.ChangePassword(txtCurrentPassword.Text, _
                  txtNewPassword.Text) Then
                displayMessage("Haso zostao zmienione.")
            Else
                displayMessage("Zmiana hasa zakoczya si niepowodzeniem.")
            End If
        Else
            displayMessage("Nie zostay wypenione wymagane pola.")
        End If
    End Sub

    Protected Sub btnChangePasswordQuestion_Click( _
      ByVal sender As Object, _
      ByVal e As System.EventArgs) _
      Handles btnChangePasswordQuestion.Click
        Dim user As MembershipUser = Membership.GetUser
        If txtCurrentPassword.Text <> "" And _
           txtPasswordQuestion.Text <> "" And _
           txtPasswordAnswer.Text <> "" Then
            If user.ChangePasswordQuestionAndAnswer( _
               txtCurrentPassword.Text, _
               txtPasswordQuestion.Text, _
               txtPasswordAnswer.Text) Then
                displayMessage("Pytanie przypominajce haso zostao zmienione.")
            Else
                displayMessage("Zmiana pytania przypominajcego haso zakoczya si niepowodzeniem.")
            End If
        Else
            displayMessage("Nie zostay wypenione wymagane pola.")
        End If
    End Sub

    Protected Sub btnUpdateEmail_Click(ByVal sender As Object, _
      ByVal e As System.EventArgs) _
      Handles btnUpdateEmail.Click
        Dim user As MembershipUser = Membership.GetUser
        user.Email = txtEmail.Text
        Membership.UpdateUser(user)
        displayMessage("Adres email zosta uaktualniony.")
    End Sub

End Class
