Imports System.IO

Partial Class _Default
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            TreeView1.Nodes.Add(New _
               TreeNode(Request.PhysicalApplicationPath))
            getSubDirectories(Request.PhysicalApplicationPath, _
               TreeView1.Nodes(0))
        End If

    End Sub

    Public Sub getSubDirectories(ByVal path As String, _
      ByVal node As TreeNode)
        '---Pobiera podkatalogi w biecym katalogu.
        Dim dirs As String() = Directory.GetDirectories(path)

        '---Brak podkatalogw.
        If dirs.Length = 0 Then
            Exit Sub
        Else
            '---W przypadku kadego podkatalogu, dodaj go do kontrolki TreeView 
            ' i powtrz rekurencyjne procedur.
            Dim dir As String
            For Each dir In dirs
                '---Dodaj wzgldn ciek do kontrolki TreeView.
                Dim newNode As New TreeNode( _
                      dir.Substring(dir.LastIndexOf("\") + 1))
                newNode.ToolTip = dir
                node.ChildNodes.Add(newNode)
                '---Odszukaj jego podkatalogi.
                getSubDirectories(dir, newNode)
                '---Odszukaj wszystkie pliki.
                getFiles(dir, newNode)
                '---Zamknij biecy wze.
                newNode.CollapseAll()
            Next
        End If
    End Sub


    Public Sub getFiles(ByVal path As String, ByVal node As TreeNode)
        Dim files As String() = Directory.GetFiles(path)
        Dim file As String

        '---Brak plikw i podkatalogw w biecym katalogu.
        If files.Length = 0 And node.ChildNodes.Count = 0 Then
            Dim newNode As New TreeNode("Katalog jest pusty.")
            node.ChildNodes.Add(newNode)
            Exit Sub
        End If
        For Each file In files
            '---Dodaj plik do kontrolki TreeView.
            Dim newNode As New TreeNode(file.Substring(path.Length + 1))
            newNode.ToolTip = file
            newNode.ImageUrl = "Images\file.gif"
            node.ChildNodes.Add(newNode)
        Next
    End Sub

End Class
