Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts

Public Class TranslationWebPart
    Inherits WebPart

    Private pStrText As String = Nothing
    Private txtStringToTranslate As TextBox

    Private lblTranslatedString As Label

    Public Sub New()
        Me.AllowClose = True
    End Sub

    <Personalizable(), WebBrowsable()> _
    Public Property strToTranslate() As String
        Get
            Return pStrText
        End Get
        Set(ByVal value As String)
            pStrText = value
        End Set
    End Property

    Protected Overrides Sub CreateChildControls()
        Controls.Clear()
        '---Wywietl pole tekstowe.
        txtStringToTranslate = New TextBox()
        txtStringToTranslate.Text = Me.strToTranslate
        Me.Controls.Add(txtStringToTranslate)

        '---Wywietl przycisk.
        Dim btnTranslate As New Button()
        btnTranslate.Text = "Tumacz"
        AddHandler btnTranslate.Click, AddressOf Me.btnTranslate_Click
        Me.Controls.Add(btnTranslate)

        '---Wywietl etykiet.
        lblTranslatedString = New Label()
        lblTranslatedString.BackColor = _
           System.Drawing.Color.Yellow
        Me.Controls.Add(lblTranslatedString)
        ChildControlsCreated = True
    End Sub

    Private Sub btnTranslate_Click(ByVal sender As Object, _
          ByVal e As EventArgs)
        '---Wywietl przetumaczone zdanie.
        If txtStringToTranslate.Text <> String.Empty Then
            Me.strToTranslate = txtStringToTranslate.Text
            txtStringToTranslate.Text = String.Empty

            '--Dostp do usugi sieciowej.
            Dim ws As New com.webservicex.www.TranslateService
            lblTranslatedString.Text = "<br/>" & Me.strToTranslate & "-->" & _
            ws.Translate(com.webservicex.www.Language.EnglishTOFrench, _
            Me.strToTranslate)
        End If
    End Sub
End Class
