﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

//async/await
using System.Threading;
using System.Threading.Tasks;

//caller information
using System.Runtime.CompilerServices;

namespace AsyncDemo
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        Task<long> DoSomethingAsync(object argument)
        {
            //czynność, która będzie wykonywana asynchronicznie
            Func<object, long> akcja =
                (object _argument) =>
                {
                    Label1.Text += "<br />Początek działania akcji - " + _argument.ToString();
                    Thread.Sleep(5000); //opóźnienie 5s
                    Label1.Text += "<br />Koniec działania akcji - " + _argument.ToString();

                    return DateTime.Now.Ticks;
                };

            Task<long> zadanie = new Task<long>(akcja, argument);
            zadanie.Start();
            return zadanie;
        }

        Task DoSomethingVoidAsync(object argument)
        {
            //czynność, która będzie wykonywana asynchronicznie
            Action<object> akcja =
                (object _argument) =>
                {
                    Label1.Text += "<br />Początek działania akcji - " + _argument.ToString();
                    Thread.Sleep(5000); //opóźnienie 5s
                    Label1.Text += "<br />Koniec działania akcji - " + _argument.ToString();
                };

            Task zadanie = new Task(akcja, argument);
            zadanie.Start();
            return zadanie;
        }
            
        protected async void Button1_Click(object sender, EventArgs e)
        {
            Label1.Text += "<br />[Początek Button1_Click]";

            Func<object, long> akcja =
                (object argument) =>
                {
                    Label1.Text += "<br />Początek działania akcji - " + argument.ToString();
                    Thread.Sleep(5000); //opóźnienie 5s
                    Label1.Text += "<br />Koniec działania akcji - " + argument.ToString();
                    return DateTime.Now.Ticks;
                };

            ////1) akcja wykonywana synchronicznie
            //long wynik = akcja("synchronicznie");
            //Label1.Text += "<br />Synchronicznie: " + wynik.ToString();

            ////2) akcja wykonywana asynchronicznie przez zadanie
            //Task<long> zadanie = new Task<long>(akcja, "zadanie");
            //zadanie.Start();
            //Label1.Text += "<br />Akcja została uruchomiona";
            //long wynik = zadanie.Result; //własność Result czeka ze zwróceniem wartości aż zadanie zostanie zakończone (synchronizacja)
            //Label1.Text += "<br />Zadanie: " + wynik.ToString();

            ////3) akcja wykonywana asynchronicznie przez zadanie - metoda tworzaca zadanie
            //Task<long> zadanie = DoSomethingAsync("zadanie-metoda");
            //Label1.Text += "<br />Akcja została uruchomiona (metoda)";
            //long wynik = zadanie.Result;
            //Label1.Text += "<br />Zadanie-metoda: " + wynik.ToString();

            ////4) akcja wykonywana asynchronicznie - async/await
            //Task<long> zadanie = DoSomethingAsync("async/await");
            //Label1.Text += "<br />Akcja została uruchomiona (zadanie-metoda-await)";
            //long wynik = await zadanie;
            //Label1.Text += "<br />Zadanie-async/await: " + wynik.ToString();

            //5) akcja wykonywana asynchronicznie - async/await bez Task
            long wynik = await DoSomethingAsync("async/await");
            Label1.Text += "<br />Zadanie-async/await: " + wynik.ToString();

            ////6) akcja wykonywana asynchronicznie - async/await bez Task
            //await DoSomethingVoidAsync("async/await");
            //Label1.Text += "<br />Po zadaniu";

            //Koniec
            Label1.Text += "<br />[Koniec Button1_Click]";
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            Label1.Text += "<br />[Początek Button2_Click]";

            Button1_Click(null, null);

            //Koniec
            Label1.Text += "<br />[Koniec Button2_Click]";
        }

        public void PokazInformacje(
            string zwyklyArgument,
            [CallerMemberName] string memberName = "",
            [CallerFilePath] string sourceFilePath = "",
            [CallerLineNumber] int sourceLineNumber = 0)
        {
            string s = "Informacje o miejscu wywołania metody:<br />";
            s += "nazwa elementu składowego: " + memberName + "<br />";
            s += "ścieżka pliku z kodem źródłowym: " + sourceFilePath + "<br />";
            s += "numer linii, w której nastąpiło wywołanie: " + sourceLineNumber + "<br />";
            Label1.Text = s;
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            PokazInformacje("zwykły argument");
        }

    }
}