﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Web.Caching;

namespace WebApplication1
{
    public partial class Buforowanie : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            this.tbxCurrentDate.Text = DateTime.Now.ToString();
            this.tbxCachedDate.Text = GetDateFromCache().ToString();
        }

        private DateTime GetDateFromCache()
        {
            DateTime date = DateTime.MinValue;

            if (HttpRuntime.Cache["date"] != null)
            {
                date = (DateTime)HttpRuntime.Cache["date"];
            }
            else
            {
                date = DateTime.Now;
                //HttpRuntime.Cache.Add("date", date, null, DateTime.Now.AddSeconds(30), Cache.NoSlidingExpiration, CacheItemPriority.Normal, null);
                HttpRuntime.Cache.Add("date", date, null, Cache.NoAbsoluteExpiration, TimeSpan.FromSeconds(30), CacheItemPriority.Normal, null);
            }

            return date;
        }
    }
}