 Imports System
 Imports System.Collections
 Imports System.Web
 Imports System.Web.UI
 Namespace NewRiders
       <ParseChildren(true)> _
       Public Class Converter : Inherits Control
                    Implements INamingContainer
          Private _itemTemplate As ITemplate = Nothing
          <TemplateContainer(GetType(ConverterItem))> _
          Public Property ItemTemplate As ITemplate
             Get
                return _itemTemplate
             End Get
             Set
                _itemTemplate = value
             End Set
          End Property
          Private _dataSource As ICollection = Nothing
          Public Property DataSource As ICollection
             Get
                Return _dataSource
             End Get
             Set
               _dataSource = Value
             End Set
          End Property
          Private _type as String = "temperatura"
          Public Property Type as String
             Get
                Return _type
             End Get
             Set
                _type = Value
             End Set
          End Property
          Protected Overrides Sub OnDataBinding(E As EventArgs)
             If Not DataSource Is Nothing
                Dim DataEnum As IEnumerator = _
                             DataSource.GetEnumerator()
                Dim I As Integer = 0
                Do While (DataEnum.MoveNext())
                    Dim Item As ConverterItem = _
                        New ConverterItem(I, DataEnum.Current,Type)
                    ItemTemplate.InstantiateIn(Item)
                    Controls.Add(Item)
                    I = I + 1
                Loop
             End If
          End Sub
    End Class
    Public Class ConverterItem : Inherits Control
                 Implements INamingContainer
       Private _sourceValue as Integer, _targetValue as Integer
       Private _sourceUnit as String, _targetUnit as String
       Private _ItemIndex As Integer
       Public ReadOnly Property ItemIndex As Integer
          Get
             return _ItemIndex
          End Get
       End Property
       Public Sub New(ItemIndex As Integer, SourceData As Object, Type as String)
          MyBase.New()
         _ItemIndex = ItemIndex
          Select Case Type.ToLower()
             Case "odlego"
                 _sourceUnit = "mil"
                 _targetUnit = "kilometrom"
                 _sourceValue = CType(SourceData, Integer)
                 _targetValue = CType((_sourceValue * 1.609), Integer)
             Case Else 'temperatura
                 _sourceUnit = "&deg F"
                 _targetUnit = "&deg C"
                 _sourceValue = CType(SourceData, Integer)
                 _targetValue = CType((5.0/9.0) * (_sourceValue - 32), Integer)
          End Select
       End Sub
       Public ReadOnly Property SourceUnit as String
          Get
             return _sourceUnit	
          End Get
       End Property
       Public ReadOnly Property TargetUnit as String
          Get
                return _targetUnit	
          End Get
    End Property
       Public ReadOnly Property SourceValue As Object
          Get
             return _sourceValue
          End Get
       End Property
       Public ReadOnly Property TargetValue As Object
          Get
             return _targetValue
          End Get
       End Property
   End Class
 End Namespace