 Option Strict Off
 Imports System
 Imports System.Web
 Imports System.Web.UI
 Imports System.Web.UI.WebControls
 NameSpace NewRiders
     Public Class Converter : Inherits Control
                   Implements INamingContainer
        Private _type as String, _label1 as String, _label2 as String
        Public Property Type as String
           Get
               return _type
           End Get
           Set
              _type = Value.ToLower()
              Select Case _type
                 Case "odlego"
                    _label1 = "mile"
                    _label2 = "kilometry"
                 Case Else 'temperatura
                    _label1 = "&deg F"
                    _label2 = "&deg C"
              End Select
           End Set
        End Property
        Private _convertedValue as Integer
        Public ReadOnly Property ConvertedValue as Integer
           Get
              Dim Ctrl As TextBox = Controls(0)
              Dim SourceValue as Integer
              SourceValue =  Int32.Parse(Ctrl.Text)
              Select Case Type
                 Case "odlego"
                   _convertedValue =  CType((SourceValue * 1.609), Integer)
                 Case Else 'temperatura
                   _convertedValue = CType((5.0/9.0) * _
                              (SourceValue - 32), Integer)
              End Select
              return _convertedValue
            End Get
        End Property
        Protected Overrides Sub CreateChildControls()
           Dim Box as New TextBox
           Box.Text = "0"
           Box.Columns = 5
           Me.Controls.Add(Box)
           Me.Controls.Add(New LiteralControl(" " & _label1 & _
                           " na " & _label2 & "<BR>"))
           Dim ConvertButton as new Button
           ConvertButton.Text = "Konwertuj"
           AddHandler ConvertButton.Click, AddressOf ConvertBtn_Click
           Me.Controls.Add(ConvertButton)
           Me.Controls.Add(New LiteralControl("<HR>Warto po skonwertowaniu: "))
           Dim Result as New Label
           Me.Controls.Add(Result)
        End Sub
        Private Sub ConvertBtn_Click(Sender as Object, E as EventArgs)
           Dim Ctrl As Label = Controls(4)
           Ctrl.Text = ConvertedValue
    End Sub
  End Class
 End NameSpace