Imports System
 Imports System.Web.UI
 NameSpace NewRiders
  Public Class ConverterFormat
     Private _bgcolor as String
     Public Property BgColor as String
        Get
           return _bgcolor
        End Get
        Set
           bgcolor = Value
        End Set
     End Property
     Private _width as String
     Public Property Width as String
        Get
           return _width
        End Get
        Set
           width = Value
        End Set
     End Property
     Private _height as String
     Public Property Height as String
        Get
           return _height
        End Get
        Set
           height = Value
        End Set
     End Property
  End Class
  Public Class Converter : Inherits Control
     Private _format as ConverterFormat = new ConverterFormat()
     Public ReadOnly Property Format as ConverterFormat
        Get
           return _format
        End Get
     End Property
     Private _type as String, _label1 as String, _label2 as String
     Public Property Type as String
        Get
           return _type
        End Get
        Set
           type = Value.ToLower()
           Select Case _type
              Case "odlego"
                 _label1 = "mile"
                 _label2 = "kilometry"
              Case Else 'temperatura
                 _label1 = "&deg F"
                 _label2 = "&deg C"
           End Select
        End Set
     End Property
     Overrides Protected Sub Render(Output as HtmlTextWriter)
        Output.Write("<Table bgcolor='" & Format.BgColor & "")
        Output.Write(" Height='" & Format.Height & "")
        Output.WriteLine(" Width='" & Format.Width & ">")
        Output.WriteLine("<tr><td>")
        Output.Write("<input name=" & Me.UniqueID & " size='5'> ")
        Output.WriteLine(_label1 & " na " & _label2)
        Output.WriteLine("</td></tr>")
        Output.WriteLine("</table>")
     End Sub
  End Class
 End NameSpace