   Imports System.Text
   Imports System.Security.Cryptography
   
   Public Module MyCryptoLib
   
   ...

    Public Function Encrypt( _
                      ByVal s As String, _
                      ByVal Password As String _
                    ) As String

      ' Pobranie do tablicy bajtowej danych do zaszyfrowania
      Dim data() As Byte = Encoding.ASCII.GetBytes(s)

      ' Utworzenie instancji CSP
      Dim des As New DESCryptoServiceProvider()

      ' Utworzenie tablic do przechowywania klucza i IV dla tego szyfru
      Dim key() As Byte
      Dim iv() As Byte

      ' Utworzenie klucza i IV odpowiednich dla szyfru DES
      GenerateKey(Password, des.BlockSize, key, iv)
      des.Key = key
      des.IV = iv

      ' Utworzenie bezpiecznego strumienia IO w pamici, aby uniezaleni si od plikw tymczasowych
      Dim mout As New MemoryStream()

      ' Utworzenie strumienia szyfrujcego
      Dim encStream As New CryptoStream(mout, des.CreateEncryptor(), CryptoStreamMode.Write)

     Dim i As Long

     ' Zapisanie zawartoci acucha (we fragmentach) do strumienia
     For i = 0 To data.Length - 1 Step 4096
       encStream.Write(data, i * 4096, data.Length - (i * 4096))
     Next

     ' "Wypukanie" wszystkich danych do wyjcia, konieczne dla otrzymania prawidowych wynikw
     encStream.FlushFinalBlock()

     ' Utworzenie tablicy do przechowywania wynikw szyfrowania
     Dim result(mout.Length - 1) As Byte

     ' Ustawienie wskanika na pocztek stromienia pamiciowego
     mout.Seek(0, SeekOrigin.Begin)

     ' Wczytanie strumienia do result()
     mout.Read(result, 0, result.Length)

     ' Zamknicie utworzonych strumieni
     encStream.Close()
     mout.Close()

     ' Skonwertowanie wyniku do postaci zakodowanej Base64, dla zachowania binarnej
     ' integralnoci zaszyfrownych danych i zwrcenie wyniku
     Return Convert.ToBase64String(result)

   End Function

   Public Function Decrypt( _
                     ByVal s As String, _
                     ByVal Password As String _
                   ) As String

     ' Pobranie do tablicy bajtowej danych do zdeszyfrowania
     Dim data() As Byte = Convert.FromBase64String(s)

     ' Utworzenie instancji CSP
     Dim des As New DESCryptoServiceProvider()

     ' Utworzenie tablic do przechowywania klucza i IV dla tego szyfru
     Dim key() As Byte
     Dim iv() As Byte

     ' Utworzenie klucza i IV odpowiednich dla szyfru DES
     GenerateKey(Password, des.BlockSize, key, iv)
     des.Key = key
     des.IV = iv

     ' Utworzenie bezpiecznego strumienia IO w pamici, aby uniezaleni si od plikw tymczasowych
     Dim mout As New MemoryStream()

     ' Utworzenie strumienia deszyfrujcego
     Dim decStream As New CryptoStream(mout, des.CreateDecryptor(), CryptoStreamMode.Write)

     Dim i As Long

     ' Zapisanie zawartoci acucha (we fragmentach) do strumienia
     For i = 0 To data.Length - 1 Step 4096
       decStream.Write(data, i * 4096, data.Length - (i * 4096))
     Next

     ' "Wypukanie" wszystkich danych do wyjcia, konieczne dla otrzymania prawidowych wynikw
     decStream.FlushFinalBlock()

     ' Utworzenie tablicy do przechowywania wynikw deszyfrowania
     Dim result(mout.Length - 1) As Byte

     '  Ustawienie wskanika na pocztek stromienia pamiciowego
     mout.Seek(0, SeekOrigin.Begin)

     ' Wczytanie strumienia do result()
     mout.Read(result, 0, result.Length)

     ' Zamknicie utworzonych strumieni
     encStream.Close()
     mout.Close()

     ' Konwertowanie wynikw do postaci tekstu ASCII
     Return Encoding.ASCII.GetString(result)

   End Function

 ...

 End Module
