   Imports System.Text
   Imports System.Security.Cryptography
   
   Public Module MyCryptoLib
   
   ...

    Public Sub GenerateKey( _
                 ByVal Password As String, _
                 ByVal BlockSize As Integer, _
                 ByRef Key() As Byte, _
                 ByRef IV() As Byte)

      Dim I As Integer

      ' data() zawiera reprezentacj ASCII hasa
      Dim data() As Byte = Encoding.ASCII.GetBytes(Password)

      ' hash() bdzie zawiera tymczasowy wynik dziaania funkcji skrtu
      Dim hash() As Byte

      ' sha stanowi implementacj SHA1 CSP
      Dim sha As New SHA1CryptoServiceProvider()

      ' Konieczne jest obliczenie klucza i wektora inicjalizujcego Initialization Vector (IV)
      ' odpowiedniego do dugoci bloku algorytmu szyfrujcego, ktry ma by uyty. Rozmiar 
      ' bloku (BlockSize) w bitach jest dzielony przez 8, aby dugo wyraaa si w bajtach
       Dim len As Integer = BlockSize / 8

      ' Okrelenie rozmiaru klucza (Key) i IV do przechowywania wynikowego skrtu
       ReDim Key(len - 1)
       ReDim IV(len - 1)

      ' Obliczenie skrtu dla klucza ASCII
      hash = sha.ComputeHash(data)

      ' Pobranie czci wynikowego skrtu w celu zastosowania jako klucza
      For I = 0 To len - 1
        Key(I) = hash(I)
      Next

      ' Pobranie czci wynikowego skrtu w celu zastosowania jako IV
      For I = len To (2 * len) - 1
        IV(I - len) = hash(I)
      Next

    End Sub

    ...

 End Module
