﻿<?xml version="1.0" encoding="UTF-8"?>
 <xsl:stylesheet
   version="1.0"
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <!-- Nagłówek biblioteki, pokazywany w divLibrary --> 
   <xsl:template match="/library">
     <b>Biblioteka:</b>
     <ul>
       <xsl:apply-templates select="book"/>
     </ul>
   </xsl:template>
  
   <!-- Spis książek, pokazywany w divLibrary -->
   <xsl:template match="book">
     <li>
       <a href="javascript:BookClick('{@uri}');">
         <xsl:value-of select="@title"/>
       </a>
     </li>
   </xsl:template>
 
   <!-- Nagłówek książki, pokazywany w divBook -->
   <xsl:template match="/book">
     <b>Książka:</b> "<xsl:value-of select="@title"/>"
     <ul>
       <xsl:apply-templates select="chapter"/>
     </ul>
   </xsl:template>
  
   <!-- Spis rozdziałów, pokazywany divBook -->
   <xsl:template match="chapter">
     <li>
       <a href="javascript:ChapterClick('{@uri}');">
         <xsl:value-of select="@title"/>
       </a>
     </li> 
   </xsl:template>
 
   <!-- Zawartość rozdziału, pokazawana w divChapter -->
   <xsl:template match="/chapter">
     <h3><xsl:value-of select="@title"/></h3>
     <xsl:value-of select="text()"/>
   </xsl:template>
 
 </xsl:stylesheet>