 <html>
   <script runat="server" language="VB">
    
     Sub Page_Load(Sender As Object, E As EventArgs)
       ' Deklaracje
       Dim xmlDocument As System.Xml.XmlDataDocument
       Dim Conn As New System.Data.SqlClient.SqlConnection()
       Dim Adapter As New System.Data.SqlClient.SqlDataAdapter()
       Dim Results As New System.Data.DataSet()
       Dim nodeFirstName As System.Xml.XmlElement

       ' Otwarcie poczenia z DataSet
       Conn.ConnectionString = "Initial Catalog=Northwind;Data Source=localhost;User ID=sa;Password=;"
       Conn.Open()

       ' Wypenienie zbioru danych wynikami zapytania SQL
       Adapter.SelectCommand = New System.Data.SqlClient.SqlCommand("SELECT FirstName FROM Employees", Conn)
       Adapter.Fill(Results)

       ' Zwrcenie zbioru danych z wartociami:
       '
       '   Name
       '   ______
       '   Nancy
       '   Andrew
       '   Janet
       '   ...
       '   Anne

       ' Powizanie zbioru danych Results z obiektem XmlDataDocument
       xmlDocument = New System.Xml.XmlDataDocument(Results)

       ' Wypisanie zawartoci XmlDataDocument
       Response.Write("Struktura XML obiektu ADO.NET DataSet:<br>")
       WriteXml(xmlDocument.outerXml)

       ' Usunicie ogranicze wizw, co pozwoli na modyfikowanie zbioru rekordw w XmlDataDocument
       Results.EnforceConstraints = False

       ' Pobranie pierwszego pola
       nodeFirstName = xmlDocument.selectSingleNode("//FirstName")

       ' Zmiana wartoci pola
       nodeFirstName.InnerText = "Ron"
      
       ' Zmiana drugiej wartoci
       Results.Tables(0).Rows(1).Item("FirstName") = "Bob"
   
       ' Dataset wyglda teraz nastpujco
       '
       '   Name
       '   ______
       '   Ron
       '   Bob
       '   Janet
       '   ...
       '   Anne

       ' Wypisanie biecego zbioru danych ADO.Net
       Response.Write("Struktura XML obiektu ADO.NET DataSet po zmianach :<br>")
         WriteXml(xmlDocument.outerXml)

     End Sub

     Public Sub WriteXml(ByVal s As String)
       s = Server.HtmlEncode(s)
       s = Replace(s, "&gt;&lt;", "&gt;" & "<BR>" & "&lt;")
       s = "<pre>" & s & "</pre>"
      
       Response.Write(s)
       
     End Sub
    
   </script>
  
 </html>