 <%@ Import Namespace="System.Data" %>
 <html>
 <script language="VB" runat="server">

  Dim Cart As DataTable

  Function CreateDataSource() As ICollection 
    Dim dt As DataTable 
    Dim dr As DataRow 
    dt = new DataTable()

    dt.Columns.Add(new DataColumn("IntegerValue", System.Type.GetType("System.Int32") ))
    dt.Columns.Add(new DataColumn("StringValue", System.Type.GetType("System.String") ))
    dt.Columns.Add(new DataColumn("CurrencyValue", System.Type.GetType("System.Double") ))

    Dim i As Integer     
    For i = 1 To 10
      dr = dt.NewRow()
      dr(0) = i
      dr(1) = "Przedmiot " & i 
      dr(2) = 1.323 * i
      dt.Rows.Add(dr)
    Next i

    Dim dv As DataView 
    dv = new DataView(dt)
    CreateDataSource = dv
  End Function

  Sub Page_Load(sender As Object, e As EventArgs)
    If Not IsPostBack
      ' dane trzeba zaadowa tylko raz
      ItemsGrid.DataSource= CreateDataSource()
      ItemsGrid.DataBind()
    End If
  End Sub

  Sub Grid_CartCommand(sender As Object, e As DataGridCommandEventArgs) 
     Message.Text = "Wybrae " + e.Item.Cells(1).Text
  End Sub
 </script>

 <body>
 <center>

 <form runat=server>
 <asp:Label id="Message" runat="server"/>
 <br>
 <table cellpadding="5">
 <tr valign="top">
  <td>
    <b>Lista produktw</b>
    <asp:DataGrid id="ItemsGrid" runat="server"
      BorderColor="black"
      BorderWidth="1"
      CellPadding="3"
      HeaderStyle-BackColor="#F6F6F6"
      AutoGenerateColumns="false"
      OnItemCommand="Grid_CartCommand">

      <Columns>
        <asp:ButtonColumn HeaderText="Wybierz" ButtonType="PushButton" 
          Text="Wybierz" CommandName="Select" />
        <asp:BoundColumn HeaderText="Numer" DataField="IntegerValue"/>
        <asp:BoundColumn HeaderText="Przedmiot" DataField="StringValue"/>
        <asp:BoundColumn HeaderText="Cena" DataField="CurrencyValue" DataFormatString="{0:c}"
          ItemStyle-HorizontalAlign="right" />
      </Columns>
    </asp:DataGrid>
  </td>
 </tr>
 </table>
 </form>
 </center>
 </body>
 </html>