   <%@ Import Namespace="System.Web.Security" %>
   <html>
     <head>
       <script runat="server" language="vb">	
         Private Sub Page_Load(ByVal Sender As Object, _
                               ByVal e As EventArgs)
  
           Dim lUseDefault As Integer = -1
           Dim lTimeWindow As Integer = 7200 ' Dwie godziny
          Dim fForceLogin As Boolean = False ' Bez rcznego logowania
          Dim SelfURL As String = "http://" & Request.Url.Host & _
                Request.Url.AbsolutePath
          Dim PassportMgr As PassportIdentity = _
                CType(Context.Current.User.Identity, PassportIdentity)

          If PassportMgr.GetFromNetworkServer() Then         
            Response.Redirect(SelfURL)
          End If

          If PassportMgr.GetIsAuthenticated(lTimeWindow, fForceLogin, _
               False) Then

            lblMessage.Text = "Witamy na naszej witrynie!"
  
          ElseIf PassportMgr.HasTicket Then
            PassportMgr.LoginUser(HttpUtility.UrlEncode(SelfURL), _
                                  lTimeWindow, _
                                  fForceLogin, _
                                  vbNullString, _
                                  lUseDefault, _
                                  vbNullString, _
                                  lUseDefault, _
                                  False, _
                                  vbNullString)

          Else

            lblMessage.Text = "Prosz si zalogowa."
  
          End If
  
          lblLogoTag.Text = _
            PassportMgr.LogoTag2(HttpUtility.UrlEncode(SelfURL), _
                                 lTimeWindow, _
                                 fForceLogin, _
                                 vbNullString, _
                                 lUseDefault, _
                                 False, _
                                 vbNullString, _
                                 lUseDefault, _
                                 False)
  
        End Sub
      </script>
    </head>
    <body>
      <asp:label runat="server" id="lblMessage"/>
      <br>
      <asp:label runat="server" id="lblLogoTag"/>
    </body>
  </html>
