<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
  <head>
    <title>CustomValidator Control Sample</title>
    <script runat="server" language="C#">
      void CheckUniqueUserName(Object s, ServerValidateEventArgs e)
      {
        string username = e.Value.ToLower();
        if(username == "zak" || username == "cristian")
        {
          e.IsValid = false;
        }
      }
      
      void submitButton_Click(Object s, EventArgs e)
      {
        if(Page.IsValid)
        {
          submitButton.Text = "Valid";
        }
        else
        {
          submitButton.Text = "Invalid!";
        }
      }
    </script>
  </head>
  <body>
    <form runat="server">
      <p>
        New Username:<br />
        <asp:TextBox ID="usernameTextBox" runat="server" />
        <asp:CustomValidator ID="usernameUnique" runat="server"
            ControlToValidate="usernameTextBox"
            OnServerValidate="CheckUniqueUserName"
            ErrorMessage="This username already taken!" />
      </p>
      <p>
        <asp:Button ID="submitButton" runat="server"
            OnClick="submitButton_Click" Text="Submit" />
      </p>
    </form>
</body>
</html>