﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CSVLicznik licznik = new CSVLicznik(Server.MapPath("licznik.csv"));
        licznik.ZmienWartosc(Request.Path, DateTime.Now);
        int k = licznik.ZwrocDzien(Request.Path, DateTime.Now);
        licznik.Zapisz();
        Response.Write(k);
    }
}
public class CSVLicznik
{
    List<string> indeksy = new List<string>();
    List<List<string>> zawartosc = new List<List<string>>();
    string sciezka;
    public CSVLicznik(string sciezka)
    {
        this.sciezka = sciezka;
        if (!File.Exists(sciezka))
        {
            indeksy.Add("data");
            indeksy.Add(this.PobierzDate(DateTime.Now));
            zawartosc.Add(new List<string> { "Default.aspx", "0" });
        }
        else
        {
            string[] dane = File.ReadAllLines(sciezka);
            indeksy.AddRange(dane[0].Split(';'));
            for (int i = 1; i < dane.Length; i++)
                zawartosc.Add(dane[i].Split(';').ToList<string>());
        }
    }
    public void Zapisz()
    {
        string indeksyStr = String.Join(";", indeksy.ToArray());
        string[] s = new string[zawartosc.Count+1];
        s[0] = indeksyStr;
        int i = 1;
        foreach (List<string> l in zawartosc)
        {
            s[i] = String.Join(";", l.ToArray());
            i += 1;
        }
        File.WriteAllLines(sciezka, s);
    }
    public Dictionary<string, int> ZwrocCalosc(string strona)
    {
        foreach (List<string> l in zawartosc)
        {
            if (l[0] == strona)
            {
                Dictionary<string, int> d = new Dictionary<string, int>();
                for (int i=1;i<indeksy.Count;i++)
                    d.Add(indeksy[i], Convert.ToInt32(l[i]));
                return d;
            }
        }
        return null;
    }
    public int ZwrocDzien(string strona, DateTime dzien)
    {
        string data = this.PobierzDate(dzien);
        Dictionary<string, int> d = this.ZwrocCalosc(strona);
        if (d != null)
            return d[data];
        else
            return -1;
    }
    public void DodajStrone(string strona)
    {
        List<string> nowa = new List<string> { strona };
        for (int i = 0; i < indeksy.Count - 2; i++)
            nowa.Add("0");
        nowa.Add("1");
        zawartosc.Add(nowa);
    }
    public void ZmienWartosc(string strona, DateTime dzien)
    {
        string data = this.PobierzDate(dzien);
        int indeks = this.PobierzWiersz(strona);
        if (indeks > -1)
        {
            int indeksDaty = indeksy.IndexOf(data);
            if (indeksDaty > -1)
            {
                string v = zawartosc[indeks][indeksDaty];
                int l = Convert.ToInt32(v) + 1;
                zawartosc[indeks][indeksDaty] = l.ToString();
            }
            else
            {
                indeksy.Add(data);
                foreach (List<string> l in zawartosc)
                {
                    if (l[0] == strona)
                        l.Add("1");
                    else
                        l.Add("0");
                }
            }
        }
        else
            this.DodajStrone(strona);
    }
    int PobierzWiersz(string strona)
    {
        for (int i = 0; i < zawartosc.Count; i++)
            if (zawartosc[i][0] == strona)
                return i;
        return -1;
    }
    string PobierzDate(DateTime dt)
    {
        return dt.Date.ToString("yyyy-MM-dd");
    }
}