using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

public partial class ExtenderTesterNoAtlas : System.Web.UI.Page
{
   /// <summary>
   /// Handles user selection events for the GridView of Books
   /// </summary>
   protected void grdBookList_Selected(object sender, EventArgs e)
   {
      string isbn = (string)grdBookList.SelectedDataKey.Value;

      BookCatalogLogic logic = new BookCatalogLogic();
      Book book = logic.GetBookByIsbn(isbn);
      if (book != null) DisplayBook(book);
   }

   /// <summary>
   /// Click event for search button
   /// </summary>
   protected void btnSearch_Click(object sender, EventArgs e)
   {
      // try to retrieve book for entered text
      BookCatalogLogic logic = new BookCatalogLogic();
      EntityCollection<Book> books = logic.GetBooksByTitle(txtSearch.Text);
      // if found a book then display it in Book panel
      if (books == null || books.Count <= 0)
         labNotFound.Text = "Book Not Found";
      else
         DisplayBook(books[0]);
   }

   /// <summary>
   /// Displays the book contents in the Book Panel
   /// </summary>
   private void DisplayBook(Book book)
   {
      labNotFound.Text = "";
      labBookTitle.Text = book.Title;
      labBookAuthors.Text = book.AuthorsCommaList;
      labBookPublisher.Text = book.BookPublisher.Name;
      labBookDesc.Text = book.BriefDescription;
   }
}
