<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ExtenderTester.aspx.cs" Inherits="ExtenderTester" %>

<%@ Register Assembly="AtlasControlToolkit" Namespace="AtlasControlToolkit" TagPrefix="atlasToolkit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
	<title>Atlas Control Extender Tester</title>
	<link href="chapterStyles.css" type="text/css" rel="stylesheet" />
</head>
<body>
   <form id="form1" runat="server">
      <atlas:ScriptManager ID="atlasSM" runat="server" EnablePartialRendering="true" />
	   <div id="container">
			<h1>Atlas Control Extender Tester</h1>
			<p>
			This page illustrates the use of several Atlas control extenders
			</p>  
         <div id="sideArea"> 

            <asp:Panel ID="panSearchHeader" runat="server" >
               <h2 class="boxHeading">Search</h2>
               <div class="headerButton"><asp:Image ID="imgHeaderSearch" runat="server" ImageUrl="~/images/minimize.gif"/></div>
            </asp:Panel>
            <asp:Panel ID="panSearch" runat="server" CssClass="box">
               <div class="insideBox">
                  <asp:TextBox ID="txtSearch" runat="server" />
                  <asp:button ID="btnSearch" runat="server" Text="Go" OnClick="btnSearch_Click" /><br />
                  <asp:Label ID="labNotFound" runat="server" />
                  <div id="drpSearchDiv" class="transparent"></div>
                  
                                    
                  <atlas:UpdateProgress ID="upProd" runat="server" >
                     <ProgressTemplate>
                        <asp:Image runat="server" id="imgProgress" ImageUrl="~/images/progressBar.gif" /> Loading ...
                     </ProgressTemplate>
                  </atlas:UpdateProgress>                  
               </div>
            </asp:Panel>      

            <asp:Panel ID="panPublisherHeader" runat="server" >
               <h2 class="boxHeading">Publishers</h2>
               <div class="headerButton"><asp:Image ID="imgHeaderPublisher" runat="server" ImageUrl="~/images/minimize.gif"/></div>
            </asp:Panel>
            <asp:Panel ID="panPublisher" runat="server" CssClass="box">
               <div class="insideBox">
                  <asp:Repeater ID="rptPublishers" runat="server" DataSourceID="dsPublishers">
                     <ItemTemplate>
                        <asp:Panel CssClass="popupMenu" ID="panPopUpMenu" runat="server">
                           <div style="border:1px outset white">
                              &nbsp;<asp:LinkButton ID="LinkButton1" runat="server" CommandName="ViewBooks" Text="View Books"></asp:LinkButton>&nbsp;
                              <br />
                              &nbsp;<asp:LinkButton ID="LinkButton2" runat="server" CommandName="ViewDetails" Text="View Details"></asp:LinkButton>&nbsp;
                              <br />

                              &nbsp;<asp:LinkButton ID="LinkButton4" runat="server" CommandName="SeeRss" Text="See RSS Feed"></asp:LinkButton>&nbsp;
                              
                           </div>
                        </asp:Panel>    
                                         
                        <asp:Panel ID="panRepeaterItem" runat="server" CssClass="publisherItems">
                           <%# Eval("PublisherName") %> 
                        </asp:Panel>
                        
                        <atlasToolkit:HoverMenuExtender ID="hme2" runat="Server">
                           <atlasToolkit:HoverMenuProperties 
                              PopupControlID="panPopUpMenu" TargetControlID="panRepeaterItem" 
                              OffsetX="-40" PopDelay="25" PopupPosition="Right"
                              HoverCssClass="popupHover" />
                        </atlasToolkit:HoverMenuExtender>                        
                     </ItemTemplate>
                  </asp:Repeater>              
               </div>
            </asp:Panel>                     
         </div>
         
         <div id="mainArea">
            <asp:Panel ID="panBookListHeader" runat="server" >
               <h2 class="boxHeading">Books in Database</h2>
               <div class="headerButton"><asp:Image ID="imgHeaderBookList" runat="server" ImageUrl="~/images/minimize.gif"/></div>
            </asp:Panel>
            <atlas:UpdatePanel ID="upBookList" runat="server">
               <ContentTemplate>            
                  <asp:Panel ID="panBookList" runat="server" CssClass="box">
                     <div class="insideBox">
                        <asp:GridView ID="grdBookList" runat="server" DataSourceID="dsBooks"
                          AutoGenerateColumns="False"
                          AllowPaging="true" PageSize="4"
                          DataKeyNames="Isbn" GridLines="None"
                          CellPadding="4" ShowHeader="false"
                          OnSelectedIndexChanged="grdBookList_SelectedIndexChanged">

                           <Columns>
                              <asp:CommandField ShowSelectButton="true" ButtonType="Image"
                                 SelectImageUrl="images/btn_select.gif"/>             
                              <asp:BoundField DataField="Title" />           
                           </Columns>
                        </asp:GridView> 
                     </div> 
                  </asp:Panel> 
                </ContentTemplate>
            </atlas:UpdatePanel>
            
            <asp:Panel ID="panBookHeader" runat="server" >
               <h2 class="boxHeading">Book Details</h2>
               <div class="headerButton"><asp:Image ID="imgHeaderBook" runat="server" ImageUrl="~/images/minimize.gif"/></div>
            </asp:Panel>   
            <atlas:UpdatePanel ID="upBook" runat="server">
               <ContentTemplate>                              
                  <asp:Panel ID="panBook" runat="server" CssClass="box">
                     <div class="insideBox">
                        <h2><asp:Label ID="labBookTitle" runat="server" /></h2>
                        <p class="bookAuthors"><asp:Label ID="labBookAuthors" runat="server" /></p>
                        <p class="bookPublisher"><asp:Label ID="labBookPublisher" runat="server" /></p>
                        <p class="bookDesc"><asp:Label ID="labBookDesc" runat="server" /></p>
                     </div>
                  </asp:Panel>   
              </ContentTemplate>
              <Triggers>
                  <atlas:ControlEventTrigger ControlID="btnSearch" EventName="Click" />
                  <atlas:ControlEventTrigger ControlID="grdBookList" EventName="SelectedIndexChanged" />
              </Triggers>
            </atlas:UpdatePanel>                        
         </div>
	   </div>
	   

      
      <atlas:AutoCompleteExtender ID="AutoCompleteExtender1" MinimumPrefixLength="1" runat="server" 
         ServiceMethod="GetTitleSuggestions" ServicePath="BookService.asmx" >

         <atlas:AutoCompleteProperties TargetControlID="txtSearch" Enabled="true" />
      </atlas:AutoCompleteExtender>



      <atlasToolkit:CollapsiblePanelExtender ID="cpe" runat="server">

         <atlasToolkit:CollapsiblePanelProperties
            Collapsed="False"
            TargetControlID="panSearch"
            ExpandControlID="panSearchHeader"
            CollapseControlID="panSearchHeader"       
            ExpandDirection="Vertical"
            ImageControlID="imgHeaderSearch"
            ExpandedImage="~/images/restore.gif"
            ExpandedText="Collapse"
            CollapsedImage="~/images/minimize.gif"
            CollapsedText="Expand"
            SuppressPostBack="true" /> 
            
         <atlasToolkit:CollapsiblePanelProperties
            Collapsed="False"
            TargetControlID="panBookList"
            ExpandControlID="panBookListHeader"
            CollapseControlID="panBookListHeader"       
            ExpandDirection="Vertical"
            ImageControlID="imgHeaderBookList"
            ExpandedImage="~/images/restore.gif"
            ExpandedText="Collapse"
            CollapsedImage="~/images/minimize.gif"
            CollapsedText="Expand"
            SuppressPostBack="true" />    
            
         <atlasToolkit:CollapsiblePanelProperties
            Collapsed="False"
            TargetControlID="panBook"
            ExpandControlID="panBookHeader"
            CollapseControlID="panBookHeader"       
            ExpandDirection="Vertical"
            ImageControlID="imgHeaderBook"
            ExpandedImage="~/images/restore.gif"
            ExpandedText="Collapse"
            CollapsedImage="~/images/minimize.gif"
            CollapsedText="Expand"
            SuppressPostBack="true" />      
            
         <atlasToolkit:CollapsiblePanelProperties 
            Collapsed="False"
            TargetControlID="panPublisher"
            ExpandControlID="panPublisherHeader"
            CollapseControlID="panPublisherHeader"       
            ExpandDirection="Vertical"
            ImageControlID="imgHeaderPublisher"
            ExpandedImage="~/images/restore.gif"
            ExpandedText="Collapse"
            CollapsedImage="~/images/minimize.gif"
            CollapsedText="Expand"
            SuppressPostBack="true" />                                
            
      </atlasToolkit:CollapsiblePanelExtender>           


		<asp:SqlDataSource ID="dsBooks" runat="server"
	    ProviderName="System.Data.SqlClient"  
	    ConnectionString="<%$ ConnectionStrings:BookCatalog %>"
	    SelectCommand="SELECT ISBN,Title FROM Books" />
		<asp:SqlDataSource ID="dsPublishers" runat="server"
	    ProviderName="System.Data.SqlClient"  
	    ConnectionString="<%$ ConnectionStrings:BookCatalog %>"
	    SelectCommand="SELECT PublisherId,PublisherName,PublisherWebSite,PublisherRSS FROM Publishers" />	    
	</form>
</body>
</html>
