using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.SqlClient;

public partial class UsingStoredProcedures : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      
      // specifies database connection. Change this if needed
      string connString = ConfigurationManager.ConnectionStrings["BookCatalog"].ConnectionString;
      SqlConnection conn = new SqlConnection(connString);

      try
      {
         conn.Open();

         // create a command using a stored procedure name
         SqlCommand cmd = new SqlCommand();
         cmd.Connection = conn;
         cmd.CommandText = "RetrieveAllBooks";
         cmd.CommandType = CommandType.StoredProcedure;

         SqlDataReader reader = cmd.ExecuteReader();

         grdBooks.DataSource = reader;
         grdBooks.DataBind();
         reader.Close();

         SqlCommand cmdB = new SqlCommand();
         cmdB.Connection = conn;
         cmdB.CommandText = "CountBooksForPublisher";
         cmdB.CommandType = CommandType.StoredProcedure;
         cmdB.Parameters.AddWithValue("@pubId", 6);

         SqlParameter param = new SqlParameter();
         param.ParameterName = "@nBooks";
         param.Size = 2;
         param.Direction = ParameterDirection.Output;
         cmdB.Parameters.Add(param);

         int nrows = cmdB.ExecuteNonQuery();
         labMsg.Text = (string)param.Value;

         conn.Close();
      }
      catch (Exception ex)
      {
         labMsg.Text = "Error occurred accessing the database";
         labMsg.Text += "<br/>" + ex.Message;
      }
      finally
      {
         conn.Close();
      }
    }
}
