<%@ Page Language="C#" AutoEventWireup="true" CodeFile="TestObjectDataSource.aspx.cs" Inherits="TestObjectDataSource" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Using ObjectDataSource</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
</head>
<body>
   <form id="form1" runat="server">
      <div id="container">
         <h1>Using ObjectDataSource control</h1>
         <p>
         This example illustrates how to use <code>ObjectDataSource</code> controls. Each
         of these controls make use of a sample Data Access object. 
         </p>
         <h2>Select Publisher</h2>
         <asp:DropDownList ID="drpPublisher" runat="server"
           DataSourceID="objCatalog" DataValueField="PublisherId"
           DataTextField="PublisherName" AutoPostBack="True" />
           
         <h2>Books by the selected publisher</h2>
         <asp:GridView ID="grdBooks" runat="server" 
           DataSourceID="dsBooks" CellPadding="5"/>
         
         <asp:ObjectDataSource ID="objCatalog" runat="server" 
            EnableCaching="false" 
            SelectMethod="GetAll" TypeName="PublisherDA" />    
            
         <asp:ObjectDataSource ID="dsBooks" runat="server"
            SelectMethod="GetBooksByPublisher" TypeName="BookDA" >
            <SelectParameters>
               <asp:ControlParameter ControlID="drpPublisher"
                  Name="id" PropertyName="SelectedValue"
                  Type="Int32" />
            </SelectParameters>
         </asp:ObjectDataSource>                 
      </div>
   </form>
</body>
</html>
