using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.OleDb;

public partial class FillingMultipleDataTables : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      // specifies database connection. Change this if needed
      string connString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=";
      connString += Server.MapPath("~/App_Data/BookCatalogSystem.mdb") + ";";

      DataSet ds = new DataSet();

      try
      {
         // set up and open connection
         OleDbConnection conn = new OleDbConnection(connString);
         conn.Open();

         OleDbDataAdapter adapter = new OleDbDataAdapter();

         // set up first command
         string sqlBooks = " SELECT * FROM Books";
         OleDbCommand cmdBooks = new OleDbCommand(sqlBooks, conn);
         adapter.SelectCommand = cmdBooks;
       
         adapter.Fill(ds, "BooksTable");

         // set up second command
         string sqlAuthors = " SELECT * FROM Authors";
         OleDbCommand cmdAuthors = new OleDbCommand(sqlAuthors, conn);
         adapter.SelectCommand = cmdAuthors;

         adapter.Fill(ds, "AuthorsTable");   

         // use filled DataSet
         grdAuthors.DataSource = ds.Tables["AuthorsTable"].DefaultView;
         grdAuthors.DataBind();

         grdBooks.DataSource = ds.Tables["BooksTable"].DefaultView;
         grdBooks.DataBind();

         // all done so close connection
         conn.Close();
      }
      catch (Exception ex)
      {
         // process exception
      }

    }
}
