using System;
using System.Data;
using System.Data.Common;

/// <summary>
/// Klasa dostpu do danych dla BookDA
/// </summary>
public class BookDA: AbstractDA 
{
   protected override string SelectStatement
   {
      get { 
         return "SELECT ISBN,Title,YearPublished FROM Books";
      }
   }

   /// <summary>
   /// Zwraca tabel danych zawierajc infrormacje o ksice o danym identyfikatorze.
   /// Naley zwrci uwag, e ten zbir danych bdzie zawiera 0 lub 1 wiersz.
   /// </summary>
   public DataTable GetBooksByPublisher(int id)
   {
      // tworzenie zapytania z parametrem
      string sql = SelectStatement + " WHERE PublisherId=@id";

      // tworzenie tablicy parametrw
      DbParameter[] parameters = new DbParameter[] {
       MakeParameter("@id", id, DbType.Int32)
                               };
      // zwrcenie wyniku
      return GetDataTable(sql, parameters);
   }

   /// <summary>
   /// Zwraca tabel danych zawierajc dane ksiki o podanym numerze isbn.
   /// Naley zwrci uwag, e ten zbir danych bdzie zawiera 0 lub 1 wiersz.
   /// </summary>
   public DataTable GetBooksByIsbn(string isbn)
   {
      // tworzenie zapytania z parametrem
      string sql = SelectStatement + " WHERE ISBN=@isbn";

      // tworzenie tablicy parametrw
      DbParameter[] parameters = new DbParameter[] {
      MakeParameter("@isbn", isbn, DbType.String)
                              };
      // zwrcenie wyniku
      return GetDataTable(sql, parameters);
   }

   /// <summary>
   /// Aktualizacja danych wybranej ksiki
   /// </summary>
   public void UpdateBook(string isbn, string title, int yearPublished)
   {
      string sql = "UPDATE Books SET Title=@title, YearPublished=@yearPub";
      sql += " WHERE ISBN=@isbn";

      // tworzenie tablicy parametrw
      DbParameter[] parameters = new DbParameter[] {
       MakeParameter("@isbn", isbn, DbType.String),
         MakeParameter("@title", title, DbType.String),
         MakeParameter("@yearPub", yearPublished, DbType.Int32)
                               };
      // wykonanie zapytania
      RunNonQuery(sql, parameters);
   }
}
