using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UsingArrayList : System.Web.UI.Page
{
   // since we will 
   private ArrayList _customers;

   private void Page_Load(object sender, System.EventArgs e)
   {
      // Tworzenie kolekcji klientw
      _customers = new ArrayList();

      // wypenianie kolekcji klientow danymi
      FillCustomers();

      if (!IsPostBack)
      {
         lboxCustomers.DataSource = _customers;
         lboxCustomers.DataBind();
         panCustomer.Visible = false;
      }
   }

   /// <summary>
   /// Wypelnia kolekcj klientw danymi
   /// </summary>
   private void FillCustomers()
   {
     // Utworzenie przykadowych obiektw klientw
     Customer c1 = new Customer("334", "Tomasz", "Halicki", "123-4567");
     Customer c2 = new Customer("123", "Jacek", "Rusek", "456-1267");
     Customer c3 = new Customer("085", "Dawid", "Murek", "564-7823");
     Customer c4 = new Customer("254", "Martin", "Tajemniczy", "253-6383");

     // dodanie obiektw klientw do kolekcji
      _customers.Add(c1);
      _customers.Add(c2);
      _customers.Add(c3);
      _customers.Add(c4);
   }

/// <summary>
/// Wywowana po wybraniu elementu listy
/// </summary>
protected void SelectCustomer(object sender, System.EventArgs e)
{
   // odczytanie indeksu wybranego klienta
   int index = lboxCustomers.SelectedIndex;

   // jeeli indeks jest prawidowy ...
   if (index >= 0 && index <= _customers.Count)
   {
      // to odczytujemy obiekt Customer
      // z kolekcji obiektw Customer
      Customer c = (Customer)_customers[index];

      // wypenienie pl formularza
      txtId.Text = c.Id;
      txtFirst.Text = c.FirstName;
      txtLast.Text = c.LastName;
      txtPhone.Text = c.Phone;

      // pokazanie panelu zawierajcego pola tekstowe
      panCustomer.Visible = true;
   }
}
}
